<?php

namespace Tanzsport\API;

use GuzzleHttp\Psr7\Response;

class BinaryResponse
{

	/**
	 * @var Response
	 */
	private $response;

	public function __construct(Response $response)
	{
		$this->response = $response;
	}

	/**
	 * @param $contentType
	 * @param $filename
	 * @codeCoverageIgnore
	 */
	public function passTroughAs($contentType, $filename)
	{
		// clear all output buffers
		while (@ob_end_clean()) ;
		// prevent session locking
		@session_write_close();
		// disable zlib compression
		ini_set('zlib.output_compression', 'Off');

		header('Content-Type: ' . $contentType, true);
		header('Content-Transfer-Encoding: binary');
		header('Content-Disposition: inline; filename="' . $filename . '"');
		header('Content-Length: ' . $this->response->getContentLength());
		header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
		header('Pragma: public');
		header('Expires: 0');
		header('Connection: close');
		echo $this->response->getBody(true);

		exit;
	}

	public function handle(callable $handler)
	{
		return call_user_func($handler, $this->response);
	}
}
