<?php
namespace Tanzsport\Validation;

use PHPUnit\Framework\TestCase;

class BindingResultTest extends TestCase
{

	public function testEmpty()
	{
		$br = BindingResult::createEmpty();
		$this->assertFalse($br->isError());
		$this->assertEmpty($br->getAllErrors());

		$this->assertNotNull($br->getErrors('xxx'));
		$this->assertEmpty($br->getErrors('xxx'));

		ob_start();
		$br->printErrors('xxx');
		$errstr = ob_get_clean();
		$this->assertEmpty($errstr);
	}

	public function testPrint()
	{
		$br = BindingResult::createEmpty();
		$br->addError('xxx', 'MSG');

		ob_start();
		$br->printErrors('xxx');
		$errstr = ob_get_clean();
		$this->assertEquals('<p class="error">MSG</p>', $errstr);
	}
} 
