<?php
namespace Tanzsport\Util;

use PHPUnit\Framework\TestCase;

class SerializerTest extends TestCase
{

	public function testWithEncryption()
	{
		$h = new Serializer('abcdefghiklmn');
		$value = array('a', 'b', 'c');

		$enc1 = $h->serializeAndEncrypt($value);
		$enc2 = $h->serializeAndEncrypt($value);

		$dec1 = $h->decryptAndDeserialize($enc1);
		$dec2 = $h->decryptAndDeserialize($enc2);

		$this->assertEquals($value, $dec1);
		$this->assertEquals($value, $dec2);
		$this->assertEquals($dec1, $dec2);
	}

	public function testWithoutEncryption()
	{
		$h = new Serializer(null);
		$value = array('a', 'b', 'c');

		$enc1 = $h->serializeAndEncrypt($value);
		$enc2 = $h->serializeAndEncrypt($value);

		$dec1 = $h->decryptAndDeserialize($enc1);
		$dec2 = $h->decryptAndDeserialize($enc2);

		$this->assertEquals($value, $dec1);
		$this->assertEquals($value, $dec2);
		$this->assertEquals($dec1, $dec2);
	}

}
