<?php
namespace Tanzsport\Util;

use PHPUnit\Framework\TestCase;

class ClientPersistenceHandlerTest extends TestCase
{

	public function testStoreRetrieveResetWithEncryption()
	{
		$h = new ClientPersistenceHandler('TEST', new Serializer('abcdefghiklmn'), 365);
		$value = array('a', 'b', 'c');

		$h->store($value);
		$r = $h->retrieve();
		$this->assertNotNull($r);
		$this->assertEquals($value, $r);

		$h->remove();
		$this->assertNull($h->retrieve());
	}

	public function testStoreRetrieveResetWithOutEncryption()
	{
		$h = new ClientPersistenceHandler('TEST', new Serializer(null), 365);
		$value = array('a', 'b', 'c');

		$h->store($value);
		$r = $h->retrieve();
		$this->assertNotNull($r);
		$this->assertEquals($value, $r);

		$h->remove();
		$this->assertNull($h->retrieve());
	}
}
