<?php
namespace Tanzsport\API\Turnier;

use Tanzsport\API\AbstractAPITestCase;

class TurnierTest extends AbstractAPITestCase
{

	public function testMagicMethods()
	{
		$data = (object)array('startgruppe' => 'HGR', 'startklasse' => 'A', 'turnierart' => 'LAT');
		$t = new Turnier($data);
		$this->assertEquals('HGR', $t->startgruppe);
		$this->assertTrue(isset($t->startgruppe));
		$this->assertFalse(isset($t->unknown_property));
	}

	public function testMatches_Startgruppe()
	{
		$data = (object)array('startgruppe' => 'HGR');
		$t = new Turnier($data);

		$s = new EinzelwettbewerbSuche();

		$s->setTurnier1('HGR', null, null);
		$this->assertTrue($t->matches($s));

		$s->setTurnier1('HGR II', null, null);
		$this->assertFalse($t->matches($s));

		$s->setTurnier2('HGR', null, null);
		$this->assertTrue($t->matches($s));

		$s->setTurnier2('HGR II', null, null);
		$this->assertFalse($t->matches($s));
	}

	public function testMatches_StartgruppeStartklasse()
	{
		$data = (object)array('startgruppe' => 'HGR', 'startklasse' => 'A');
		$t = new Turnier($data);

		$s = new EinzelwettbewerbSuche();

		$s->setTurnier1('HGR', 'A', null);
		$this->assertTrue($t->matches($s));

		$s->setTurnier1('HGR', 'B', null);
		$this->assertFalse($t->matches($s));

		$s->setTurnier2('HGR', 'A', null);
		$this->assertTrue($t->matches($s));

		$s->setTurnier2('HGR II', 'A', null);
		$this->assertFalse($t->matches($s));
	}

	public function testMatches_StartgruppeStartklasseTurnierart()
	{
		$data = (object)array('startgruppe' => 'HGR', 'startklasse' => 'A', 'turnierart' => 'LAT');
		$t = new Turnier($data);

		$s = new EinzelwettbewerbSuche();

		$s->setTurnier1('HGR', 'A', 'LAT');
		$this->assertTrue($t->matches($s));

		$s->setTurnier1('HGR', 'A', 'ST');
		$this->assertFalse($t->matches($s));

		$s->setTurnier2('HGR', 'A', 'LAT');
		$this->assertTrue($t->matches($s));

		$s->setTurnier2('HGR II', 'A', 'LAT');
		$this->assertFalse($t->matches($s));
	}

	public function testMatches_Liga()
	{
		$data = (object)array('bemerkung' => 'Landesliga Nord Gruppe A Latein');
		$t = new Turnier($data);

		$s = new FormationswettbewerbSuche();

		$s->setLiga('Landesliga');
		$this->assertTrue($t->matches($s));

		$s->setLiga('Regionalliga');
		$this->assertFalse($t->matches($s));
	}

	public function testMatches_LigaTurnierart()
	{
		$data = (object)array('bemerkung' => 'Landesliga Nord Gruppe A Latein');
		$t = new Turnier($data);

		$s = new FormationswettbewerbSuche();

		$this->assertFalse($t->matches($s));

		$s->setLiga('Landesliga');
		$s->setTurnierart('Latein');
		$this->assertTrue($t->matches($s));

		$s->setLiga('Landesliga');
		$s->setTurnierart('Standard');
		$this->assertFalse($t->matches($s));

		$s->setLiga('Regionalliga');
		$s->setTurnierart('Latein');
		$this->assertFalse($t->matches($s));

		$s->setLiga('Regionalliga');
		$s->setTurnierart('Standard');
		$this->assertFalse($t->matches($s));
	}

	public function testMatchesJmd_F()
	{
		$data = (object)array('bemerkung' => 'Regionalliga');
		$t = new Turnier($data);

		$s = new JmdWettbewerbSuche();
		$this->assertFalse($t->matches($s));

		$s->addWettbewerbsart('X');
		$this->assertFalse($t->matches($s));

		$s->addWettbewerbsart('F');
		$this->assertTrue($t->matches($s));
	}

	public function testMatchesJmd_SG()
	{
		$data = (object)array('bemerkung' => 'Einladungsturnier Small Groups HGR II');
		$t = new Turnier($data);

		$s = new JmdWettbewerbSuche();
		$this->assertFalse($t->matches($s));

		$s->addWettbewerbsart('X');
		$this->assertFalse($t->matches($s));

		$s->addWettbewerbsart('SG');
		$this->assertTrue($t->matches($s));
	}

	public function testMatchesJmd_S()
	{
		$data = (object)array('bemerkung' => 'Berlinpokal Solo Kinder');
		$t = new Turnier($data);

		$s = new JmdWettbewerbSuche();
		$this->assertFalse($t->matches($s));

		$s->addWettbewerbsart('X');
		$this->assertFalse($t->matches($s));

		$s->addWettbewerbsart('S');
		$this->assertTrue($t->matches($s));
	}

	public function testMatchesJmd_D()
	{
		$data = (object)array('bemerkung' => 'LM Duo Jugend');
		$t = new Turnier($data);

		$s = new JmdWettbewerbSuche();
		$this->assertFalse($t->matches($s));

		$s->addWettbewerbsart('X');
		$this->assertFalse($t->matches($s));

		$s->addWettbewerbsart('D');
		$this->assertTrue($t->matches($s));
	}
}