<?php
namespace Tanzsport\API\Turnier\Resource;

use Tanzsport\API\AbstractAPITestCase;

class FormationswettbewerbResourceTest extends AbstractAPITestCase
{

	/**
	 * @var FormationswettbewerbResource
	 */
	private $r;

	public function setUp(): void
	{
		parent::setUp();
		$this->r = new FormationswettbewerbResource($this->getEndpoint());
	}

	public function testGetAlleParameter()
	{
		$this->assertNotNull($this->r->getAlleParameter());
	}

	public function testGetRegeln()
	{
		$regeln = $this->r->getRegeln();
		$this->assertNotNull($regeln);
		$this->assertTrue(is_array($regeln));
		$this->assertTrue(!empty($regeln));
	}

	public function testGetLigen()
	{
		$ligen = $this->r->getLigen();
		$this->assertNotNull($ligen);
		$this->assertTrue(is_array($ligen));
		$this->assertTrue(!empty($ligen));
	}

	public function testGetTurnierarten()
	{
		$turnierarten = $this->r->getTurnierarten('Regionalliga');
		$this->assertNotNull($turnierarten);
		$this->assertTrue(is_array($turnierarten));
		$this->assertTrue(!empty($turnierarten));
	}

	public function testFindJson()
	{
		$veranstaltungen = $this->r->findJson('01.01.2014', '31.12.2014', null, null, 'TNW', 'Regionalliga', 'Latein', true, 1, 5);
		$this->assertNotNull($veranstaltungen);
	}

	public function testFindPdf()
	{
		$response = $this->r->findPdf('01.01.2014', '31.12.2014', null, null, 'TNW', 'Regionalliga', 'Latein', false, 0, 5);
		$this->assertNotNull($response);
		$this->assertStringContainsString('application/pdf', $response->getHeader('Content-Type')[0]);
	}
}
