<?php
namespace Tanzsport\API\Lehrgang\Validation;

use PHPUnit\Framework\TestCase;
use Tanzsport\API\Lehrgang\LehrgangSuche;
use Tanzsport\Validation\BindingResult;

class LehrgangSucheValidatorTest extends TestCase
{

	/**
	 * @var LehrgangSucheValidator
	 */
	private $v;

	/**
	 * @var LehrgangSuche
	 */
	private $s;

	public function setUp(): void
	{
		$this->s = new LehrgangSuche();
		$this->v = new LehrgangSucheValidator();
	}

	public function testDatum()
	{
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertTrue($br->isError());
		$this->assertTrue($br->hasErrors('von'));
		$this->assertTrue($br->hasErrors('bis'));
		$this->assertEquals(1, count($br->getErrors('von')));
		$this->assertEquals(1, count($br->getErrors('bis')));
		$this->assertContainsError($br, 'von', 'Anfangsdatum erforderlich');
		$this->assertContainsError($br, 'bis', 'Enddatum erforderlich');

		$this->s->setVon('--invalid--');
		$this->s->setBis('--invalid--');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertTrue($br->isError());
		$this->assertTrue($br->hasErrors('von'));
		$this->assertTrue($br->hasErrors('bis'));
		$this->assertEquals(1, count($br->getErrors('von')));
		$this->assertEquals(1, count($br->getErrors('bis')));
		$this->assertContainsError($br, 'von', 'Falsches Datumsformat für Anfangsdatum');
		$this->assertContainsError($br, 'bis', 'Falsches Datumsformat für Enddatum');

		$this->s->setVon('1.1.2013');
		$this->s->setBis('1.1.2014');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertFalse($br->isError());

		$this->s->setVon('10.10.2013');
		$this->s->setBis('10.10.2014');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertFalse($br->isError());

		$this->s->setVon('10.10.2013');
		$this->s->setBis('10.10.2013');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertFalse($br->isError());

		$this->s->setVon('01.01.2014');
		$this->s->setBis('01.01.2013');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertTrue($br->isError());
		$this->assertEquals(1, count($br->getErrors('bis')));
		$this->assertContainsError($br, 'bis', 'Enddatum darf nicht vor Anfangsdatum liegen.');
	}

	private function assertContainsError(BindingResult $bindingResult, $property, $errorRegex)
	{
		if (strpos($errorRegex, '/') !== 0) {
			$errorRegex = '/' . $errorRegex;
		}
		if (strrpos($errorRegex, '/') !== strlen($errorRegex) - 1) {
			$errorRegex = $errorRegex . '/';
		}

		$found = false;

		foreach ($bindingResult->getAllErrors() as $prop => $errors) {
			if ($property == $prop) {
				foreach ($errors as $error) {
					if (preg_match($errorRegex, $error)) {
						$found = true;
					}
				}
			}
		}

		$this->assertTrue($found, "Fehlermeldung {$errorRegex} für {$property} enthalten");
	}
}
