<?php

namespace Tanzsport\API\Verein\Resource;

use Guzzle\Http\Exception\ClientErrorResponseException;
use GuzzleHttp\Exception\ClientException;
use GuzzleHttp\Exception\GuzzleException;
use Psr\Http\Client\ClientExceptionInterface;
use Tanzsport\API\AbstractResource;

class VereineResource extends AbstractResource
{

	public function find($name = null, $landesverbaende = null, $standort = null, $seite = 0, $anzahl = 10)
	{
		$query = [];
		if ($name != null) {
			$query['name'] = $name;
		}
		if ($landesverbaende != null) {
			$query['l'] = $landesverbaende;
		}
		if ($standort != null) {
			$query['standort'] = $standort;
		}
		if ($seite != null) {
			$query['seite'] = $seite;
		}
		if ($anzahl != null) {
			$query['anzahl'] = $anzahl;
		}

		return $this->getJson('1/vdb/vereine', ['query' => $query]);
	}

	public function findOne($id)
	{
		// @codeCoverageIgnoreStart
		if (!$id) {
			throw new \InvalidArgumentException('ID erforderlich!');
		}
		// @codeCoverageIgnoreEnd

		try {
			return $this->getJson('1/vdb/verein/' . $id);
		} catch (ClientException $e) {
			if ($e->getResponse()->getStatusCode() == 404) {
				return null;
			}
			throw $e;
		}
	}
}
