<?php
declare(strict_types=1);

namespace Tanzsport\API\Turnier\Resource;

class JmdWettbewerbResource extends AbstractWettbewerbResource
{

	public function getAlleParameter()
	{
		return $this->getJson('1/tdb/veranstaltungen/jmd/parameter');
	}

	public function findJson(
		$von, $bis, $plzVon = null, $plzBis = null, $typen = null, $landesverbaende = null,
		$wettbewerbsarten = null, $seite = 0, $anzahl = 10
	)
	{
		return $this->parseJson($this->findInternal($von, $bis, $plzVon, $plzBis, $typen, $landesverbaende,
			$wettbewerbsarten, $seite, $anzahl, 'application/json'));
	}

	public function findPdf(
		$von, $bis, $plzVon = null, $plzBis = null, $typen = null, $landesverbaende = null,$wettbewerbsarten = null
	)
	{
		return $this->findInternal($von, $bis, $plzVon, $plzBis, $typen, $landesverbaende, $wettbewerbsarten,
			null, null, 'application/pdf');
	}

	private function findInternal(
		$von, $bis, $plzVon = null, $plzBis = null, $typen = null, $landesverbaende = null, $wettbewerbsarten = null,
		$seite = 0, $anzahl = 10, $accept = 'application/json'
	)
	{
		// @codeCoverageIgnoreStart
		if ($von == null) {
			throw new \InvalidArgumentException("Datum von erforderlich!");
		}
		if ($bis == null) {
			throw new \InvalidArgumentException("Datum bis erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$headers = $accept ? ['Accept' => $accept] : [];
		$query = [
			'von' => $von,
			'bis' => $bis
		];
		if ($plzVon != null) {
			$query['plzVon'] = $plzVon;
		}
		if ($plzBis != null) {
			$query['plzBis'] = $plzBis;
		}
		if ($typen != null) {
			$query['typ'] = $typen;
		}
		if ($landesverbaende != null) {
			$query['l'] = $landesverbaende;
		}
		if ($wettbewerbsarten != null) {
			$query['wettbewerbsart'] = $wettbewerbsarten;
		}
		if ($seite != null) {
			$query['seite'] = $seite;
		}
		if ($anzahl != null) {
			$query['anzahl'] = $anzahl;
		}

		return $this->get('1/tdb/veranstaltungen/jmd', ['headers' => $headers, 'query' => $query]);
	}
}
