<?php
declare(strict_types=1);

namespace Tanzsport\API\Turnier\Resource;

use Psr\Http\Message\ResponseInterface;

class EinzelwettbewerbResource extends AbstractWettbewerbResource
{

	public function getAlleParameter()
	{
		return $this->getJson('1/tdb/veranstaltungen/einzel/parameter');
	}

	public function getRegeln()
	{
		return $this->getJson('1/tdb/veranstaltungen/einzel/parameter/regeln');
	}

	public function getStartgruppen()
	{
		return $this->getJson('1/tdb/veranstaltungen/einzel/parameter/startgruppen');
	}

	public function getStartklassen($startgruppe)
	{
		// @codeCoverageIgnoreStart
		if ($startgruppe == null) {
			throw new \InvalidArgumentException("Startgruppe erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$query = ['g' => $startgruppe];
		return $this->getJson('1/tdb/veranstaltungen/einzel/parameter/startklassen', ['query' => $query]);
	}

	public function getTurnierarten($startgruppe, $startklasse)
	{
		// @codeCoverageIgnoreStart
		if ($startgruppe == null) {
			throw new \InvalidArgumentException("Startgruppe erforderlich!");
		}
		if ($startklasse == null) {
			throw new \InvalidArgumentException("Startklasse erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$query = ['g' => $startgruppe, 'k' => $startklasse];
		return $this->getJson('1/tdb/veranstaltungen/einzel/parameter/turnierarten', ['query' => $query]);
	}

	public function findJson(
		$von, $bis, $plzVon = null, $plzBis = null, $typen = null, $landesverbaende = null,
		$t1gruppe = null, $t1klasse = null, $t1art = null,
		$t2gruppe = null, $t2klasse = null, $t2art = null,
		$konjunktion = null, $seite = 0, $anzahl = 10)
	{
		return $this->parseJson($this->findInternal($von, $bis, $plzVon, $plzBis, $typen, $landesverbaende, $t1gruppe,
			$t1klasse, $t1art, $t2gruppe, $t2klasse, $t2art, $konjunktion, $seite, $anzahl, 'application/json'));
	}

	public function findPdf(
		$von, $bis, $plzVon = null, $plzBis = null, $typen = null, $landesverbaende = null,
		$t1gruppe = null, $t1klasse = null, $t1art = null,
		$t2gruppe = null, $t2klasse = null, $t2art = null,
		$konjunktion = null): ResponseInterface
	{
		return $this->findInternal($von, $bis, $plzVon, $plzBis, $typen, $landesverbaende, $t1gruppe, $t1klasse,
			$t1art, $t2gruppe, $t2klasse, $t2art, $konjunktion, null, null, 'application/pdf');
	}

	private function findInternal(
		$von, $bis, $plzVon = null, $plzBis = null, $typen = null, $landesverbaende = null,
		$t1gruppe = null, $t1klasse = null, $t1art = null,
		$t2gruppe = null, $t2klasse = null, $t2art = null,
		$konjunktion = null, $seite = 0, $anzahl = 10, $accept = 'application/json'): ResponseInterface
	{
		// @codeCoverageIgnoreStart
		if ($von == null) {
			throw new \InvalidArgumentException("Datum von erforderlich!");
		}
		if ($bis == null) {
			throw new \InvalidArgumentException("Datum bis erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$headers = $accept ? ['Accept' => $accept] : [];
		$query = [
			'von' => $von,
			'bis' => $bis
		];
		if ($plzVon != null) {
			$query['plzVon'] = $plzVon;
		}
		if ($plzBis != null) {
			$query['plzBis'] = $plzBis;
		}
		if ($typen != null) {
			$query['typ'] = $typen;
		}
		if ($landesverbaende != null) {
			$query['l'] = $landesverbaende;
		}
		if ($t1gruppe != null) {
			$query['t1g'] = $t1gruppe;
			if ($t1klasse != null) {
				$query['t1k'] = $t1klasse;
				if ($t1art != null) {
					$query['t1a'] = $t1art;
				}
			}
		}
		if ($t2gruppe != null) {
			$query['t2g'] = $t2gruppe;
			if ($t2klasse != null) {
				$query['t2k'] = $t2klasse;
				if ($t2art != null) {
					$query['t2a'] = $t2art;
				}
			}
		}
		if ($konjunktion != null) {
			$query['konjunktion'] = $konjunktion;
		}
		if ($seite != null) {
			$query['seite'] = $seite;
		}
		if ($anzahl != null) {
			$query['anzahl'] = $anzahl;
		}

		return $this->get('1/tdb/veranstaltungen/einzel', ['headers' => $headers, 'query' => $query]);
	}
}
