<?php
declare(strict_types=1);

namespace Tanzsport\API\Turnier\Resource;

use GuzzleHttp\Exception\RequestException;
use Tanzsport\API\AbstractResource;

class AbstractWettbewerbResource extends AbstractResource
{

	public function findVeranstaltung(int $id)
	{
		return $this->findVeranstaltungInternal($id, 'application/json');
	}

	public function findVeranstaltungPdf(int $id)
	{
		return $this->findVeranstaltungInternal($id, 'application/pdf');
	}

	private function findVeranstaltungInternal(int $id, string $accept)
	{
		// @codeCoverageIgnoreStart
		if (!$id) {
			throw new \InvalidArgumentException("ID erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		try {
			$headers = $accept ? ['Accept' => $accept] : [];
			return $this->getJson('1/tdb/veranstaltung/' . $id, ['headers' => $headers]);
		} catch (RequestException $e) {
			if ($e->getResponse()->getStatusCode() == 404) {
				return null;
			}
			throw $e;
		}
	}

	public function findVeranstaltungMitTurnierNr(int $turnierNr)
	{
		return $this->findVeranstaltungMitTurnierNrInternal($turnierNr, 'application/json');
	}

	public function findVeranstaltungMitTurnierNrPdf(int $turnierNr)
	{
		return $this->findVeranstaltungMitTurnierNrInternal($turnierNr, 'application/pdf');
	}

	private function findVeranstaltungMitTurnierNrInternal(int $turnierNr, string $accept)
	{
		// @codeCoverageIgnoreStart
		if (!$turnierNr) {
			throw new \InvalidArgumentException("Turnier-Nr. erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		try {
			$headers = $accept ? ['Accept' => $accept] : [];
			return $this->getJson('1/tdb/veranstaltung', ['query' => ['t' => $turnierNr], 'headers' => $headers]);
		} catch (RequestException $e) {
			if ($e->getResponse()->getStatusCode() == 404) {
				return null;
			}
			throw $e;
		}
	}
}
