<?php
declare(strict_types=1);

namespace Tanzsport\API\Turnier;

/**
 * @property $gruppe string|null Startgruppe
 * @property $klasse string|null Startklasse
 * @property $turnierart string|null Turnierart
 */
class EinzelwettbewerbSucheTurnier
{

	private static $properties = ['gruppe', 'klasse', 'turnierart'];

	private ?string $gruppe = null;
	private ?string $klasse = null;
	private ?string $turnierart = null;

	public function __get($key)
	{
		return in_array($key, self::$properties) ? $this->$key : null;
	}

	public function __set($key, $value)
	{
		if (in_array($key, self::$properties)) {
			$this->$key = $value;
		}
	}

	public function __isset($key)
	{
		return in_array($key, self::$properties);
	}
}
