<?php
declare(strict_types=1);

namespace Tanzsport\API\Turnier;

class AbstractSuche
{

	private ?int $turnierNr = null;
	private ?string $von = null;
	private ?string $bis = null;
	private ?string $plzVon = null;
	private ?string $plzBis = null;
	/**
	 * @var Array<string>
	 */
	private array $landesverbaende;
	private int $seite = 0;
	private int $anzahl = 10;

	public function __construct()
	{
		$this->landesverbaende = [];
	}

	public function getVon(): ?string
	{
		return $this->von;
	}

	public function setVon(?string $von): self
	{
		$this->von = $von;
		return $this;
	}

	public function getBis(): ?string
	{
		return $this->bis;
	}

	public function setBis(?string $bis): self
	{
		$this->bis = $bis;
		return $this;
	}

	public function getPlzVon(): ?string
	{
		return $this->plzVon;
	}

	public function setPlzVon(?string $plzVon): self
	{
		$this->plzVon = $plzVon;
		return $this;
	}

	public function getPlzBis(): ?string
	{
		return $this->plzBis;
	}

	public function setPlzBis(?string $plzBis): self
	{
		$this->plzBis = $plzBis;
		return $this;
	}

	/**
	 * @return Array<string>
	 */
	public function getLandesverbaende(): array
	{
		return $this->landesverbaende;
	}

	public function addLandesverband(?string $landesverband): self
	{
		if ($landesverband != null && !in_array($landesverband, $this->landesverbaende)) {
			$this->landesverbaende[] = $landesverband;
		}
		return $this;
	}

	public function getSeite(): int
	{
		return $this->seite;
	}

	public function setSeite(int $seite): self
	{
		$this->seite = $seite;
		return $this;
	}

	public function getAnzahl(): int
	{
		return $this->anzahl;
	}

	public function setAnzahl(int $anzahl): self
	{
		$this->anzahl = $anzahl;
		return $this;
	}

	public function getTurnierNr(): ?int
	{
		return $this->turnierNr;
	}

	public function setTurnierNr(?int $turnierNr): self
	{
		$this->turnierNr = $turnierNr;
		return $this;
	}
}
