<?php
namespace Tanzsport\API;

class Page implements \Iterator, \ArrayAccess, \Countable
{

	/**
	 * @var \stdClass
	 */
	private $apiResult;

	/**
	 * @var \Closure
	 */
	private $converter;

	/**
	 * @var array
	 */
	private $converted;

	/**
	 * @var int
	 */
	private $key = 0;

	public function __construct($apiResult, \Closure $converter = null)
	{
		// @codeCoverageIgnoreStart
		if ($apiResult == null) {
			throw new \InvalidArgumentException("API-Daten erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$this->apiResult = (object)$apiResult;
		$this->converter = $converter;
		$this->converted = array();
	}

	#[\ReturnTypeWillChange]
	public function current()
	{
		return $this->offsetGet($this->key);
	}

	#[\ReturnTypeWillChange]
	public function next()
	{
		$this->key++;
	}

	#[\ReturnTypeWillChange]
	public function key()
	{
		return $this->key;
	}

	#[\ReturnTypeWillChange]
	public function valid()
	{
		return $this->key < count($this->apiResult->daten);
	}

	#[\ReturnTypeWillChange]
	public function rewind()
	{
		$this->key = 0;
	}

	#[\ReturnTypeWillChange]
	public function offsetExists($offset)
	{
		return isset($this->apiResult->daten[$offset]);
	}

	#[\ReturnTypeWillChange]
	public function offsetGet($offset)
	{
		if ($this->offsetExists($offset)) {
			$value = $this->apiResult->daten[$offset];
			if ($this->converter == null) {
				return $value;
			} else {
				if (!isset($this->converted[$offset])) {
					$this->converted[$offset] = call_user_func($this->converter, $value);
				}
				return $this->converted[$offset];
			}
		}
	}

	/**
	 * @param mixed $offset
	 * @param mixed $value
	 * @throws \RuntimeException
	 * @codeCoverageIgnore
	 */
	#[\ReturnTypeWillChange]
	public function offsetSet($offset, $value)
	{
		throw new \RuntimeException("Setting values not allowed!");
	}

	/**
	 * @param mixed $offset
	 * @throws \RuntimeException
	 * @codeCoverageIgnore
	 */
	#[\ReturnTypeWillChange]
	public function offsetUnset($offset)
	{
		throw new \RuntimeException("Unsetting values not allowed!");
	}

	#[\ReturnTypeWillChange]
	public function count()
	{
		return count($this->apiResult->daten);
	}

	public function getSeitenLaenge()
	{
		return $this->apiResult->seitenLaenge;
	}

	public function getSeite()
	{
		return $this->apiResult->seite;
	}

	public function getAnzahlGesamt()
	{
		return $this->apiResult->anzahlGesamt;
	}

	public function isErsteSeite()
	{
		return $this->apiResult->ersteSeite == 1;
	}

	public function isLetzteSeite()
	{
		return $this->apiResult->letzteSeite == 1;
	}

	public function getAnzahlDatensaetze()
	{
		return $this->apiResult->anzahlDatensaetze;
	}

	public function getSeitenAnzahl()
	{
		return $this->apiResult->seitenAnzahl;
	}

}
