<?php

namespace Tanzsport\API\Lehrgang\Resource;

use Tanzsport\API\AbstractResource;

class LehrgaengeResource extends AbstractResource
{

	/**
	 * @param $von Datum von (TT.MM.JJJJ)
	 * @param $bis Datum bis (TT.MM.JJJJ)
	 * @param string|array|null $typen
	 * @param string|array|null $ausrichter
	 * @param int $seite
	 * @param int $anzahl
	 * @throws \InvalidArgumentException
	 */
	public function find($von, $bis, $typen = null, $ausrichter = null, $seite = 0, $anzahl = 10)
	{
		// @codeCoverageIgnoreStart
		if ($von == null) {
			throw new \InvalidArgumentException("Datum von erforderlich!");
		}
		if ($bis == null) {
			throw new \InvalidArgumentException("Datum bis erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$query = [
			'von' => $von,
			'bis' => $bis,
		];
		if ($typen != null) {
			$query['typ'] = $typen;
		}
		if ($ausrichter != null) {
			$query['ausrichter'] = $ausrichter;
		}
		if ($seite != null) {
			$query['seite'] = $seite;
		}
		if ($anzahl != null) {
			$query['anzahl'] = $anzahl;
		}

		return $this->getJson('1/ldb/lehrgaenge', ['query' => $query]);
	}
}
