<?php
namespace Tanzsport\API\Lehrgang;

class LehrgangSuche
{

	/**
	 * @var string
	 */
	private $von;

	/**
	 * @var string
	 */
	private $bis;

	/**
	 * @var array
	 */
	private $typen;

	/**
	 * @var array
	 */
	private $ausrichter;

	/**
	 * @var int
	 */
	private $seite = 0;

	/**
	 * @var int
	 */
	private $anzahl = 10;

	public function __construct()
	{
		$this->typen = array();
		$this->ausrichter = array();
	}

	public function getVon()
	{
		return $this->von;
	}

	public function setVon($von)
	{
		$this->von = $von;
		return $this;
	}

	public function getBis()
	{
		return $this->bis;
	}

	public function setBis($bis)
	{
		$this->bis = $bis;
		return $this;
	}

	public function getTypen()
	{
		return $this->typen;
	}

	public function addTyp($typ)
	{
		if (!in_array($typ, $this->typen)) {
			$this->typen[] = $typ;
		}
		return $this;
	}

	public function getAusrichter()
	{
		return $this->ausrichter;
	}

	public function addAusrichter($ausrichter)
	{
		if (!in_array($ausrichter, $this->ausrichter)) {
			$this->ausrichter[] = $ausrichter;
		}
		return $this;
	}

	public function getSeite()
	{
		return $this->seite;
	}

	public function setSeite($seite)
	{
		$this->seite = $seite;
		return $this;
	}

	public function getAnzahl()
	{
		return $this->anzahl;
	}

	public function setAnzahl($anzahl)
	{
		$this->anzahl = $anzahl;
		return $this;
	}
}