<?php
namespace Tanzsport\Util;

class ClientPersistenceHandlerTest extends \PHPUnit_Framework_TestCase
{

	public function testStoreRetrieveResetWithEncryption()
	{
		$h = new ClientPersistenceHandler('TEST', new Serializer('abcdefghiklmn'), 365);
		$value = array('a', 'b', 'c');

		$h->store($value);
		$r = $h->retrieve();
		$this->assertNotNull($r);
		$this->assertEquals($value, $r);

		$h->remove();
		$this->assertNull($h->retrieve());
	}

	public function testStoreRetrieveResetWithOutEncryption()
	{
		$h = new ClientPersistenceHandler('TEST', new Serializer(null), 365);
		$value = array('a', 'b', 'c');

		$h->store($value);
		$r = $h->retrieve();
		$this->assertNotNull($r);
		$this->assertEquals($value, $r);

		$h->remove();
		$this->assertNull($h->retrieve());
	}
}
