<?php
namespace Tanzsport\API\Verein\Resource;

use Tanzsport\API\AbstractAPITestCase;

class VereineResourceTest extends AbstractAPITestCase
{

	/**
	 * @var VereineResource
	 */
	private $resource;

	public function setUp()
	{
		parent::setUp();
		$this->resource = new VereineResource($this->getEndpoint());
	}

	public function testFind()
	{

		$result = $this->resource->find('blau');
		$this->assertNotNull($result);
		$this->assertTrue(count($result['daten']) > 0);
		$this->assertEquals(0, $result['seite']);

		$result = $this->resource->find('blau', null, null, 2);
		$this->assertNotNull($result);
		$this->assertTrue(count($result['daten']) > 0);
		$this->assertEquals(2, $result['seite']);

		$result = $this->resource->find('blau', 'Berlin', null);
		$this->assertNotNull($result);
		$this->assertTrue(count($result['daten']) > 0);
		$this->assertEquals(0, $result['seite']);

		$result = $this->resource->find('blau', 'Berlin', 'Berlin');
		$this->assertNotNull($result);
		$this->assertTrue(count($result['daten']) > 0);
		$this->assertEquals(0, $result['seite']);

		$result = $this->resource->find(null, array('Berlin', 'Bayern'), null, 1, 50);
		$this->assertNotNull($result);
		$this->assertTrue(count($result['daten']) == 50);
		$this->assertEquals(1, $result['seite']);
		foreach ($result['daten'] as $v) {
			$this->assertTrue($v['ltv'] == 'Berlin' || $v['ltv'] == 'Bayern');
		}
	}

	public function testFindOne()
	{
		$result = $this->resource->findOne(318);
		$this->assertNotNull($result);
		$this->assertEquals(318, $result['nr']);

		$result = $this->resource->findOne(PHP_INT_MAX);
		$this->assertNull($result);
	}
}

