<?php
namespace Tanzsport\API\Turnier\Validation;

use Tanzsport\API\Turnier\EinzelwettbewerbSuche;
use Tanzsport\Validation\BindingResult;

class EinzelwettbewerbSucheValidatorTest extends \PHPUnit_Framework_TestCase
{

	/**
	 * @var EinzelwettbewerbSucheValidator
	 */
	private $v;

	/**
	 * @var EinzelwettbewerbSuche
	 */
	private $s;

	public function setUp()
	{
		$this->s = new EinzelwettbewerbSuche();
		$this->v = new EinzelwettbewerbSucheValidator();
	}

	public function testDatum()
	{
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertTrue($br->isError());
		$this->assertTrue($br->hasErrors('von'));
		$this->assertTrue($br->hasErrors('bis'));
		$this->assertEquals(1, count($br->getErrors('von')));
		$this->assertEquals(1, count($br->getErrors('bis')));
		$this->assertContainsError($br, 'von', 'Anfangsdatum erforderlich');
		$this->assertContainsError($br, 'bis', 'Enddatum erforderlich');

		$this->s->setVon('--invalid--');
		$this->s->setBis('--invalid--');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertTrue($br->isError());
		$this->assertTrue($br->hasErrors('von'));
		$this->assertTrue($br->hasErrors('bis'));
		$this->assertEquals(1, count($br->getErrors('von')));
		$this->assertEquals(1, count($br->getErrors('bis')));
		$this->assertContainsError($br, 'von', 'Falsches Datumsformat für Anfangsdatum');
		$this->assertContainsError($br, 'bis', 'Falsches Datumsformat für Enddatum');

		$this->s->setVon('1.1.2013');
		$this->s->setBis('1.1.2014');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertFalse($br->isError());

		$this->s->setVon('10.10.2013');
		$this->s->setBis('10.10.2014');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertFalse($br->isError());

		$this->s->setVon('10.10.2013');
		$this->s->setBis('10.10.2013');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertFalse($br->isError());

		$this->s->setVon('01.01.2014');
		$this->s->setBis('01.01.2013');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertTrue($br->isError());
		$this->assertEquals(1, count($br->getErrors('bis')));
		$this->assertContainsError($br, 'bis', 'Enddatum darf nicht vor Anfangsdatum liegen.');
	}

	public function testDatumFormatAlt1() {
		$this->s->setVon('2013-12-31');
		$this->s->setBis('2014-12-31');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertEquals(0, count($br->getErrors('von')));
		$this->assertEquals(0, count($br->getErrors('bis')));

		$this->s->setVon('2013-1-1');
		$this->s->setBis('2014-1-1');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertEquals(0, count($br->getErrors('von')));
		$this->assertEquals(0, count($br->getErrors('bis')));
	}

	public function testDatumFormatAlt2() {
		$this->s->setVon('2013/1/1');
		$this->s->setBis('2014/1/1');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertEquals(0, count($br->getErrors('von')));
		$this->assertEquals(0, count($br->getErrors('bis')));

		$this->s->setVon('2013/12/31');
		$this->s->setBis('2014/12/31');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertEquals(0, count($br->getErrors('von')));
		$this->assertEquals(0, count($br->getErrors('bis')));
	}

	public function testPlz()
	{
		$this->s->setVon('1.1.2013');
		$this->s->setBis('1.1.2014');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertFalse($br->isError());

		$this->s->setPlzVon('abc');
		$this->s->setPlzBis('def');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertTrue($br->isError());
		$this->assertEquals(1, count($br->getErrors('plzVon')));
		$this->assertContainsError($br, 'plzVon', 'Ungültige PLZ');
		$this->assertEquals(1, count($br->getErrors('plzBis')));
		$this->assertContainsError($br, 'plzBis', 'Ungültige PLZ');

		$this->s->setPlzVon('2');
		$this->s->setPlzBis('1');
		$br = $this->v->validate($this->s);
		$this->assertNotNull($br);
		$this->assertTrue($br->isError());
		$this->assertEquals(1, count($br->getErrors('plzBis')));
		$this->assertContainsError($br, 'plzBis', 'Ende des PLZ-Bereichs');
	}

	private function assertContainsError(BindingResult $bindingResult, $property, $errorRegex)
	{
		if (strpos($errorRegex, '/') !== 0) {
			$errorRegex = '/' . $errorRegex;
		}
		if (strrpos($errorRegex, '/') !== strlen($errorRegex) - 1) {
			$errorRegex = $errorRegex . '/';
		}

		$found = false;

		foreach ($bindingResult->getAllErrors() as $prop => $errors) {
			if ($property == $prop) {
				foreach ($errors as $error) {
					if (preg_match($errorRegex, $error)) {
						$found = true;
					}
				}
			}
		}

		$this->assertTrue($found, "Fehlermeldung {$errorRegex} für {$property} enthalten");
	}
}