<?php
namespace Tanzsport\API\Turnier;

class SuchergebnisTest extends \PHPUnit_Framework_TestCase
{

	public function testConverter()
	{
		$t = new \stdClass();
		$t->startgruppe = 'HGR';

		$apiResult = array(
			'daten' => array(
				array('datum' => '2014-09-27T22:00:00.000+0000', 'turniere' => array($t), 'property' => 'abc')
			)
		);

		$e = new Suchergebnis($apiResult);
		$v = $e->offsetGet(0);
		$this->assertTrue($v instanceof Veranstaltung);

		$this->assertTrue(isset($v->datum));
		$this->assertEquals('28.09.2014', $v->datum->format('d.m.Y'));

		$this->assertTrue(isset($v->turniere));
		$this->assertTrue(is_array($v->turniere));
		$this->assertCount(1, $v->turniere);

		$this->assertTrue($v->turniere[0] instanceof Turnier);
		$this->assertEquals('HGR', $v->turniere[0]->startgruppe);

		$this->assertTrue(isset($v->property));
		$this->assertEquals('abc', $v->property);

		$this->assertFalse(isset($v->unknown_property));
	}
} 