<?php
namespace Tanzsport\API\Turnier\Resource;

use Tanzsport\API\AbstractAPITestCase;

class JmdWettbewerbResourceTest extends AbstractAPITestCase
{

	/**
	 * @var JmdWettbewerbResource
	 */
	private $r;

	public function setUp()
	{
		parent::setUp();
		$this->r = new JmdWettbewerbResource($this->getEndpoint());
	}

	public function testGetAlleParameter()
	{
		$this->assertNotNull($this->r->getAlleParameter());
	}

	public function testFindJson()
	{
		$veranstaltungen = $this->r->findJson('01.01.2010', '31.12.2014', null, null, 'JMD', 'Berlin', "F", 1, 5);
		$this->assertNotNull($veranstaltungen);
	}

	public function testFindPdf()
	{
		$response = $this->r->findPdf('01.01.2010', '31.12.2014', null, null, "TAF", null, null, 0, 5);
		$this->assertNotNull($response);
		$this->assertContains('application/pdf', $response->getContentType());
	}
}