<?php
namespace Tanzsport\API;

class PageTest extends \PHPUnit_Framework_TestCase
{

	public function testPage()
	{
		$o = new \stdClass();
		$o->x = 'b';

		$apiResult = array(
			'daten' => array('a', $o),
			'seitenLaenge' => 2,
			'seite' => 0,
			'anzahlGesamt' => 4,
			'anzahlDatensaetze' => 2,
			'seitenAnzahl' => 2,
			'ersteSeite' => true,
			'letzteSeite' => false,
		);

		$p = new Page($apiResult);
		$this->assertEquals(2, $p->getAnzahlDatensaetze());
		$this->assertEquals(4, $p->getAnzahlGesamt());
		$this->assertEquals(2, $p->getSeitenLaenge());
		$this->assertEquals(0, $p->getSeite());
		$this->assertEquals(2, $p->getSeitenAnzahl());
		$this->assertTrue($p->isErsteSeite());
		$this->assertFalse($p->isLetzteSeite());

		$this->assertEquals(2, $p->count());
		$this->assertTrue($p->valid());
		$this->assertEquals(0, $p->key());
		$this->assertEquals('a', $p->current());
		$this->assertTrue($p->valid());
		$p->next();
		$this->assertTrue($p->valid());
		$this->assertEquals(1, $p->key());
		$this->assertEquals($o, $p->current());
		$this->assertEquals($o, $p->offsetGet(1));

		$p->next();
		$this->assertFalse($p->valid());

		$p->rewind();
		$this->assertEquals(0, $p->key());
		$this->assertTrue($p->valid());

		$this->assertNull($p->offsetGet(1200));
	}

	public function testWithConverter()
	{
		$apiResult = array(
			'daten' => array('a', 'b'),
			'seitenLaenge' => 2,
			'seite' => 0,
			'anzahlGesamt' => 4,
			'anzahlDatensaetze' => 2,
			'seitenAnzahl' => 2,
			'ersteSeite' => true,
			'letzteSeite' => false,
		);

		$p = new Page($apiResult, function ($input) {
			return $input . "-converted";
		});

		$this->assertEquals('a-converted', $p->offsetGet(0));
		$this->assertEquals('a-converted', $p->offsetGet(0));
		$this->assertEquals('b-converted', $p->offsetGet(1));
		$this->assertEquals('b-converted', $p->offsetGet(1));
	}
}