<?php
namespace Tanzsport\API\Lehrgang;

use Tanzsport\API\AbstractAPITestCase;

class LehrgangsDatenbankServiceTest extends AbstractAPITestCase
{

	/**
	 * @var LehrgangsDatenbankService
	 */
	private $service;

	public function setUp()
	{
		parent::setUp();
		$this->service = new LehrgangsDatenbankService($this->getEndpoint());
	}

	public function testGetParameter()
	{
		$this->assertNotNull($this->service->getParameters());
	}

	public function testSuchen()
	{
		$s = new LehrgangSuche();
		$s->setVon('01.01.2010')->setBis('31.12.2014')->addTyp('ERWERB')->addTyp('ERHALT')->addAusrichter('BERLIN')->setSeite(1)->setAnzahl(5);

		$lehrgaenge = $this->service->suchen($s);
		$this->assertNotNull($lehrgaenge);
		foreach ($lehrgaenge as $lehrgang) {
			$this->assertTrue($lehrgang instanceof Lehrgang);
		}
	}

	/**
	 * @expectedException \InvalidArgumentException
	 * @expectedExceptionMessage Suchparameter sind ungültig
	 */
	public function testFailedValidation()
	{
		$s = new LehrgangSuche();
		$this->service->suchen($s);
	}

	public function testSerialization()
	{
		$value = array(1, 2, 3);
		$serialized = $this->service->serialize($value);
		$this->assertEquals($value, $this->service->unserialize($serialized));
	}

	public function testWithPersistenceHandler()
	{
		$service = new LehrgangsDatenbankService($this->getEndpoint(), false, null, 'TD_LDB_1', 365);
		$s = $service->createDefaultSearchParameters();
		$this->assertFalse($service->validate($s)->isError());

		$this->assertEmpty($s->getTypen());
		$s->addTyp('ERHALT');
		$service->suchen($s);

		$s = $service->createDefaultSearchParameters();
		$this->assertContains('ERHALT', $s->getTypen());
	}
}