<?php
namespace Tanzsport\Validation;

class BindingResult
{

	/**
	 * @var
	 */
	private $object;

	/**
	 * @var array
	 */
	private $errors = array();

	public function __construct($object)
	{
		// @codeCoverageIgnoreStart
		if ($object == null) {
			throw new \InvalidArgumentException("Objekt erforderlich!");
		}
		// @codeCoverageIgnoreEnd
	}

	/**
	 * @return BindingResult
	 */
	public static function createEmpty()
	{
		return new BindingResult(new \stdClass());
	}

	/**
	 * @param $property
	 * @param $error
	 * @throws \InvalidArgumentException
	 */
	public function addError($property, $error)
	{
		// @codeCoverageIgnoreStart
		if ($property == null) {
			throw new \InvalidArgumentException("Property erforderlich!");
		}
		if ($error == null) {
			throw new \InvalidArgumentException("Fehlermeldung erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		if (!isset($this->errors[$property])) {
			$this->errors[$property] = array();
		}
		$this->errors[$property][] = $error;
	}

	/**
	 * @param $property
	 * @return array
	 * @throws \InvalidArgumentException
	 */
	public function getErrors($property)
	{
		// @codeCoverageIgnoreStart
		if ($property == null) {
			throw new \InvalidArgumentException("Property erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		if ($this->hasErrors($property)) {
			return $this->errors[$property];
		} else {
			return array();
		}
	}

	/**
	 * @return array
	 */
	public function getAllErrors()
	{
		return $this->errors;
	}

	/**
	 * @param $property
	 * @return bool
	 * @throws \InvalidArgumentException
	 */
	public function hasErrors($property)
	{
		// @codeCoverageIgnoreStart
		if ($property == null) {
			throw new \InvalidArgumentException("Property erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		return isset($this->errors[$property]) && count($this->errors[$property]) > 0;
	}

	/**
	 * @return bool
	 */
	public function isError()
	{
		$error = false;
		foreach ($this->errors as $property => $errors) {
			if (count($errors) > 0) {
				$error = true;
				break;
			}
		}
		return $error;
	}

	public function printErrors($property, $format = '<p class="error">%1$s</p>')
	{
		// @codeCoverageIgnoreStart
		if ($property == null) {
			throw new \InvalidArgumentException("Property erforderlich!");
		}
		if ($format == null) {
			throw new \InvalidArgumentException("Format erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		if ($this->hasErrors($property)) {
			foreach ($this->getErrors($property) as $error) {
				echo sprintf($format, $error);
			}
		}
	}
}