<?php
namespace Tanzsport\Util;

class Serializer
{

	/**
	 * @var string
	 */
	private $key = null;

	/**
	 * @var resource
	 */
	private $mcryptModule;

	public function __construct($key)
	{
		if ($key != null) {
			$this->key = mhash(MHASH_SHA256, $key);
			$this->mcryptModule = mcrypt_module_open(MCRYPT_RIJNDAEL_128, '', 'ecb', '');
		}
	}

	public function __destruct()
	{
		if ($this->mcryptModule) {
			mcrypt_module_close($this->mcryptModule);
		}
	}

	/**
	 * @param $value
	 * @return string
	 * @throws \InvalidArgumentException
	 */
	public function serializeAndEncrypt($value)
	{
		// @codeCoverageIgnoreStart
		if ($value == null) {
			throw new \InvalidArgumentException("Wert erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$serialized = serialize($value);
		if ($this->mcryptModule) {
			$initVector = mcrypt_create_iv(mcrypt_enc_get_iv_size($this->mcryptModule), MCRYPT_RAND);
			mcrypt_generic_init($this->mcryptModule, $this->key, $initVector);
			$encrypted = mcrypt_generic($this->mcryptModule, $serialized);
			mcrypt_generic_deinit($this->mcryptModule);
			return base64_encode($encrypted);
		} else {
			return base64_encode($serialized);
		}
	}

	/**
	 * @param $input
	 * @return mixed
	 * @throws \InvalidArgumentException
	 */
	public function decryptAndDeserialize($input)
	{
		// @codeCoverageIgnoreStart
		if ($input == null) {
			throw new \InvalidArgumentException("Input erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$decrypted = null;
		if ($this->mcryptModule) {
			$initVector = mcrypt_create_iv(mcrypt_enc_get_iv_size($this->mcryptModule), MCRYPT_RAND);
			mcrypt_generic_init($this->mcryptModule, $this->key, $initVector);
			$decrypted = mdecrypt_generic($this->mcryptModule, base64_decode($input));
			mcrypt_generic_deinit($this->mcryptModule);
		} else {
			$decrypted = base64_decode($input);
		}

		return unserialize($decrypted);
	}
}