<?php
namespace Tanzsport\API\Verein;

use Tanzsport\API\Verein\Resource\LTVResource;
use Tanzsport\API\Verein\Resource\StandorteResource;
use Tanzsport\API\Verein\Resource\VereineResource;

class VereinsDatenbankService
{

	/**
	 * @var string
	 */
	private $endpoint;

	/**
	 * @var VereineResource
	 */
	private $vereineResource;

	/**
	 * @var LTVResource
	 */
	private $ltvResource;

	/**
	 * @var StandorteResource
	 */
	private $standorteResource;

	public function __construct($endpoint, $enableCache = false, $cacheDir = null)
	{
		// @codeCoverageIgnoreStart
		if ($endpoint == null) {
			throw new \InvalidArgumentException("API-Endpunkt erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$this->endpoint = $endpoint;

		$this->vereineResource = new VereineResource($this->endpoint, $enableCache, $cacheDir);
		$this->ltvResource = new LTVResource($this->endpoint, $enableCache, $cacheDir);
		$this->standorteResource = new StandorteResource($this->endpoint, $enableCache, $cacheDir);
	}

	public function findStandorte($search)
	{
		return $this->standorteResource->find($search);
	}

	public function findVerein($id)
	{
		if ($id) {
			return $this->vereineResource->findOne($id);
		} else {
			return null;
		}
	}

	public function findVereine($name = null, $landesverbaende = null, $standort = null, $seite = 0, $anzahl = 10)
	{
		return $this->vereineResource->find($name, $landesverbaende, $standort, $seite, $anzahl);
	}

	public function getLandesverbaende()
	{
		return $this->ltvResource->getAll();
	}

}