<?php
namespace Tanzsport\API\Verein\Resource;

use Guzzle\Http\Exception\ClientErrorResponseException;
use Tanzsport\API\AbstractResource;

class VereineResource extends AbstractResource
{

	public function find($name = null, $landesverbaende = null, $standort = null, $seite = 0, $anzahl = 10)
	{
		$request = $this->createRequest('/1/vdb/vereine');
		if ($name != null) {
			$request->getQuery()->add('name', $name);
		}
		if ($landesverbaende != null) {
			if (is_array($landesverbaende)) {
				foreach ($landesverbaende as $l) {
					$request->getQuery()->add('l', $l);
				}
			} else {
				$request->getQuery()->add('l', $landesverbaende);
			}
		}
		if ($standort != null) {
			$request->getQuery()->add('standort', $standort);
		}
		if ($seite != null) {
			$request->getQuery()->add('seite', $seite);
		}
		if ($anzahl != null) {
			$request->getQuery()->add('anzahl', $anzahl);
		}

		return $request->send()->json();
	}

	public function findOne($id)
	{
		// @codeCoverageIgnoreStart
		if (!$id) {
			throw new \InvalidArgumentException('ID erforderlich!');
		}
		// @codeCoverageIgnoreEnd

		try {
			$request = $this->createRequest('/1/vdb/verein/' . $id);
			return $request->send()->json();
		} catch (ClientErrorResponseException $e) {
			if ($e->getResponse()->getStatusCode() == 404) {
				return null;
			}
			throw $e;
		}
	}
}
