<?php
namespace Tanzsport\API\Turnier\Resource;

class JmdWettbewerbResource extends AbstractWettbewerbResource
{

	public function getAlleParameter()
	{
		return $this->createRequest('/1/tdb/veranstaltungen/jmd/parameter')->send()->json();
	}

	public function findJson($von, $bis, $plzVon = null, $plzBis = null, $typen = null, $landesverbaende = null, $wettbewerbsarten = null, $seite = 0, $anzahl = 10)
	{
		return $this->findInternal($von, $bis, $plzVon, $plzBis, $typen, $landesverbaende, $wettbewerbsarten, $seite, $anzahl, 'application/json')->json();
	}

	public function findPdf($von, $bis, $plzVon = null, $plzBis = null, $typen = null, $landesverbaende = null, $wettbewerbsarten = null)
	{
		return $this->findInternal($von, $bis, $plzVon, $plzBis, $typen, $landesverbaende, $wettbewerbsarten, null, null, 'application/pdf');
	}

	private function findInternal($von, $bis, $plzVon = null, $plzBis = null, $typen = null, $landesverbaende = null, $wettbewerbsarten = null, $seite = 0, $anzahl = 10, $accept = 'application/json')
	{
		// @codeCoverageIgnoreStart
		if ($von == null) {
			throw new \InvalidArgumentException("Datum von erforderlich!");
		}
		if ($bis == null) {
			throw new \InvalidArgumentException("Datum bis erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$request = $this->createRequest('/1/tdb/veranstaltungen/jmd');
		$request->addHeader('Accept', $accept);
		$request->getQuery()->add('von', $von);
		$request->getQuery()->add('bis', $bis);
		if ($plzVon != null) {
			$request->getQuery()->add('plzVon', $plzVon);
		}
		if ($plzBis != null) {
			$request->getQuery()->add('plzBis', $plzBis);
		}
		if ($typen != null) {
			if (is_array($typen)) {
				foreach ($typen as $typ) {
					$request->getQuery()->add('typ', $typ);
				}
			} else {
				$request->getQuery()->add('typ', $typen);
			}
		}
		if ($landesverbaende != null) {
			if (is_array($landesverbaende)) {
				foreach ($landesverbaende as $landesverband) {
					$request->getQuery()->add('l', $landesverband);
				}
			} else {
				$request->getQuery()->add('l', $landesverbaende);
			}
		}
		if ($wettbewerbsarten != null) {
			if (is_array($wettbewerbsarten)) {
				foreach ($wettbewerbsarten as $wettbewerbsart) {
					$request->getQuery()->add('wettbewerbsart', $wettbewerbsart);
				}
			} else {
				$request->getQuery()->add('wettbewerbsart', $wettbewerbsarten);
			}
		}
		if ($seite != null) {
			$request->getQuery()->add('seite', $seite);
		}
		if ($anzahl != null) {
			$request->getQuery()->add('anzahl', $anzahl);
		}

		return $request->send();
	}
}