<?php
namespace Tanzsport\API\Turnier\Resource;

class FormationswettbewerbResource extends AbstractWettbewerbResource
{

	public function getAlleParameter()
	{
		return $this->createRequest('/1/tdb/veranstaltungen/formation/parameter')->send()->json();
	}

	public function getRegeln()
	{
		return $this->createRequest('/1/tdb/veranstaltungen/formation/parameter/regeln')->send()->json();
	}

	public function getLigen()
	{
		return $this->createRequest('/1/tdb/veranstaltungen/formation/parameter/ligen')->send()->json();
	}

	public function getTurnierarten($liga)
	{
		// @codeCoverageIgnoreStart
		if ($liga == null) {
			throw new \InvalidArgumentException("Liga erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$request = $this->createRequest('/1/tdb/veranstaltungen/formation/parameter/turnierarten');
		$request->getQuery()->add('l', $liga);

		return $request->send()->json();
	}

	public function findJson($von, $bis, $plzVon = null, $plzBis = null, $landesverbaende = null, $liga = null, $turnierart = null, $seite = 0, $anzahl = 10)
	{
		return $this->findInternal($von, $bis, $plzVon, $plzBis, $landesverbaende, $liga, $turnierart, $seite, $anzahl, 'application/json')->json();
	}

	public function findPdf($von, $bis, $plzVon = null, $plzBis = null, $landesverbaende = null, $liga = null, $turnierart = null)
	{
		return $this->findInternal($von, $bis, $plzVon, $plzBis, $landesverbaende, $liga, $turnierart, null, null, 'application/pdf');
	}

	private function findInternal($von, $bis, $plzVon = null, $plzBis = null, $landesverbaende = null, $liga = null, $turnierart = null, $seite = 0, $anzahl = 10, $accept = 'application/json')
	{
		// @codeCoverageIgnoreStart
		if ($von == null) {
			throw new \InvalidArgumentException("Datum von erforderlich!");
		}
		if ($bis == null) {
			throw new \InvalidArgumentException("Datum bis erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$request = $this->createRequest('/1/tdb/veranstaltungen/formation');
		$request->addHeader('Accept', $accept);
		$request->getQuery()->add('von', $von);
		$request->getQuery()->add('bis', $bis);
		if ($plzVon != null) {
			$request->getQuery()->add('plzVon', $plzVon);
		}
		if ($plzBis != null) {
			$request->getQuery()->add('plzBis', $plzBis);
		}
		if ($landesverbaende != null) {
			if (is_array($landesverbaende)) {
				foreach ($landesverbaende as $landesverband) {
					$request->getQuery()->add('l', $landesverband);
				}
			} else {
				$request->getQuery()->add('l', $landesverbaende);
			}
		}
		if ($liga != null) {
			$request->getQuery()->add('t1l', $liga);
			if ($turnierart != null) {
				$request->getQuery()->add('t1a', $turnierart);
			}
		}
		if ($seite != null) {
			$request->getQuery()->add('seite', $seite);
		}
		if ($anzahl != null) {
			$request->getQuery()->add('anzahl', $anzahl);
		}

		return $request->send();
	}

}