<?php
namespace Tanzsport\API\Turnier\Resource;

class EinzelwettbewerbResource extends AbstractWettbewerbResource
{

	public function getAlleParameter()
	{
		return $this->createRequest('/1/tdb/veranstaltungen/einzel/parameter')->send()->json();
	}

	public function getRegeln()
	{
		return $this->createRequest('/1/tdb/veranstaltungen/einzel/parameter/regeln')->send()->json();
	}

	public function getStartgruppen()
	{
		return $this->createRequest('/1/tdb/veranstaltungen/einzel/parameter/startgruppen')->send()->json();
	}

	public function getStartklassen($startgruppe)
	{
		// @codeCoverageIgnoreStart
		if ($startgruppe == null) {
			throw new \InvalidArgumentException("Startgruppe erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$request = $this->createRequest('/1/tdb/veranstaltungen/einzel/parameter/startklassen');
		$request->getQuery()->add('g', $startgruppe);

		return $request->send()->json();
	}

	public function getTurnierarten($startgruppe, $startklasse)
	{
		// @codeCoverageIgnoreStart
		if ($startgruppe == null) {
			throw new \InvalidArgumentException("Startgruppe erforderlich!");
		}
		if ($startklasse == null) {
			throw new \InvalidArgumentException("Startklasse erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$request = $this->createRequest('/1/tdb/veranstaltungen/einzel/parameter/turnierarten');
		$request->getQuery()->add('g', $startgruppe);
		$request->getQuery()->add('k', $startklasse);

		return $request->send()->json();
	}

	public function findJson($von, $bis, $plzVon = null, $plzBis = null, $typen = null, $landesverbaende = null, $t1gruppe = null, $t1klasse = null, $t1art = null, $t2gruppe = null, $t2klasse = null, $t2art = null, $konjunktion = null, $seite = 0, $anzahl = 10)
	{
		return $this->findInternal($von, $bis, $plzVon, $plzBis, $typen, $landesverbaende, $t1gruppe, $t1klasse, $t1art, $t2gruppe, $t2klasse, $t2art, $konjunktion, $seite, $anzahl, 'application/json')->json();
	}

	public function findPdf($von, $bis, $plzVon = null, $plzBis = null, $typen = null, $landesverbaende = null, $t1gruppe = null, $t1klasse = null, $t1art = null, $t2gruppe = null, $t2klasse = null, $t2art = null, $konjunktion = null)
	{
		return $this->findInternal($von, $bis, $plzVon, $plzBis, $typen, $landesverbaende, $t1gruppe, $t1klasse, $t1art, $t2gruppe, $t2klasse, $t2art, $konjunktion, null, null, 'application/pdf');
	}

	private function findInternal($von, $bis, $plzVon = null, $plzBis = null, $typen = null, $landesverbaende = null, $t1gruppe = null, $t1klasse = null, $t1art = null, $t2gruppe = null, $t2klasse = null, $t2art = null, $konjunktion = null, $seite = 0, $anzahl = 10, $accept = 'application/json')
	{
		// @codeCoverageIgnoreStart
		if ($von == null) {
			throw new \InvalidArgumentException("Datum von erforderlich!");
		}
		if ($bis == null) {
			throw new \InvalidArgumentException("Datum bis erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$request = $this->createRequest('/1/tdb/veranstaltungen/einzel');
		$request->addHeader('Accept', $accept);
		$request->getQuery()->add('von', $von);
		$request->getQuery()->add('bis', $bis);
		if ($plzVon != null) {
			$request->getQuery()->add('plzVon', $plzVon);
		}
		if ($plzBis != null) {
			$request->getQuery()->add('plzBis', $plzBis);
		}
		if ($typen != null) {
			if (is_array($typen)) {
				foreach ($typen as $typ) {
					$request->getQuery()->add('typ', $typ);
				}
			} else {
				$request->getQuery()->add('typ', $typen);
			}
		}
		if ($landesverbaende != null) {
			if (is_array($landesverbaende)) {
				foreach ($landesverbaende as $landesverband) {
					$request->getQuery()->add('l', $landesverband);
				}
			} else {
				$request->getQuery()->add('l', $landesverbaende);
			}
		}
		if ($t1gruppe != null) {
			$request->getQuery()->add('t1g', $t1gruppe);
			if ($t1klasse != null) {
				$request->getQuery()->add('t1k', $t1klasse);
				if ($t1art != null) {
					$request->getQuery()->add('t1a', $t1art);
				}
			}
		}
		if ($t2gruppe != null) {
			$request->getQuery()->add('t2g', $t2gruppe);
			if ($t2klasse != null) {
				$request->getQuery()->add('t2k', $t2klasse);
				if ($t2art != null) {
					$request->getQuery()->add('t2a', $t2art);
				}
			}
		}
		if ($konjunktion != null) {
			$konjunktion == true ? $request->getQuery()->add('konjunktion', true) : $request->getQuery()->add('konjunktion', false);
		}
		if ($seite != null) {
			$request->getQuery()->add('seite', $seite);
		}
		if ($anzahl != null) {
			$request->getQuery()->add('anzahl', $anzahl);
		}

		return $request->send();
	}
}