<?php
namespace Tanzsport\API\Turnier\Resource;

use Guzzle\Http\Exception\ClientErrorResponseException;
use Tanzsport\API\AbstractResource;

class AbstractWettbewerbResource extends AbstractResource
{

	/**
	 * @param $id
	 * @return \Guzzle\Http\Message\Response|null
	 */
	public function findVeranstaltung($id)
	{
		return $this->findVeranstaltungInternal($id, 'application/json');
	}

	/**
	 * @param $id
	 * @return \Guzzle\Http\Message\Response|null
	 */
	public function findVeranstaltungPdf($id)
	{
		return $this->findVeranstaltungInternal($id, 'application/pdf');
	}

	/**
	 * @param $id
	 * @param $accept
	 * @return \Guzzle\Http\Message\Response|null
	 */
	private function findVeranstaltungInternal($id, $accept)
	{
		// @codeCoverageIgnoreStart
		if (!$id) {
			throw new \InvalidArgumentException("ID erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		try {
			$request = $this->createRequest('/1/tdb/veranstaltung/' . $id);
			$request->addHeader('Accept', $accept);
			return $request->send();
		} catch (ClientErrorResponseException $e) {
			if ($e->getResponse()->getStatusCode() == 404) {
				return null;
			}
			throw $e;
		}
	}

	/**
	 * @param $turnierNr
	 * @return \Guzzle\Http\Message\Response|null
	 */
	public function findVeranstaltungMitTurnierNr($turnierNr)
	{
		return $this->findVeranstaltungMitTurnierNrInternal($turnierNr, 'application/json');
	}

	/**
	 * @param $turnierNr
	 * @return \Guzzle\Http\Message\Response|null
	 */
	public function findVeranstaltungMitTurnierNrPdf($turnierNr)
	{
		return $this->findVeranstaltungMitTurnierNrInternal($turnierNr, 'application/pdf');
	}

	/**
	 * @param $turnierNr
	 * @param $accept
	 * @return \Guzzle\Http\Message\Response|null
	 */
	private function findVeranstaltungMitTurnierNrInternal($turnierNr, $accept)
	{
		// @codeCoverageIgnoreStart
		if (!$turnierNr) {
			throw new \InvalidArgumentException("Turnier-Nr. erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		try {
			$request = $this->createRequest('/1/tdb/veranstaltung?t=' . $turnierNr);
			$request->addHeader('Accept', $accept);
			return $request->send();
		} catch (ClientErrorResponseException $e) {
			if ($e->getResponse()->getStatusCode() == 404) {
				return null;
			}
			throw $e;
		}
	}
}