<?php
namespace Tanzsport\API\Turnier;

class JmdWettbewerbSuche extends AbstractSuche
{

	/**
	 * @var array
	 */
	private $typen;

	/**
	 * @var array
	 */
	private $wettbewerbsarten;

	public function __construct()
	{
		parent::__construct();
		$this->typen = array();
		$this->wettbewerbsarten = array();
	}

	/**
	 * @return array
	 */
	public function getTypen()
	{
		return $this->typen;
	}

	/**
	 * @param $typ
	 * @return $this
	 */
	public function addTyp($typ)
	{
		if (!in_array($typ, $this->typen)) {
			$this->typen[] = $typ;
		}
		return $this;
	}

	/**
	 * @return array
	 */
	public function getWettbewerbsarten()
	{
		return $this->wettbewerbsarten;
	}

	/**
	 * @param $wettbewerbsart
	 * @return $this
	 */
	public function addWettbewerbsart($wettbewerbsart)
	{
		if (!in_array($wettbewerbsart, $this->wettbewerbsarten)) {
			$this->wettbewerbsarten[] = $wettbewerbsart;
		}
		return $this;
	}
}