<?php
namespace Tanzsport\API\Turnier;

class EinzelwettbewerbSuche extends AbstractSuche
{

	/**
	 * @var array
	 */
	private $typen;

	/**
	 * @var EinzelwettbewerbSucheTurnier
	 */
	private $turnier1;

	/**
	 * @var EinzelwettbewerbSucheTurnier
	 */
	private $turnier2;

	/**
	 * @var
	 */
	private $konjunktion;

	public function __construct()
	{
		parent::__construct();
		$this->typen = array();
		$this->turnier1 = new EinzelwettbewerbSucheTurnier();
		$this->turnier2 = new EinzelwettbewerbSucheTurnier();
	}

	/**
	 * @return array
	 */
	public function getTypen()
	{
		return $this->typen;
	}

	/**
	 * @param $typ
	 * @return $this
	 */
	public function addTyp($typ)
	{
		if ($typ != null && !in_array($typ, $this->typen)) {
			$this->typen[] = $typ;
		}
		return $this;
	}

	/**
	 * @return EinzelwettbewerbSucheTurnier
	 */
	public function getTurnier1()
	{
		return $this->turnier1;
	}

	/**
	 * @param $gruppe
	 * @param $klasse
	 * @param $turnierart
	 * @return $this
	 */
	public function setTurnier1($gruppe, $klasse, $turnierart)
	{
		$this->turnier1->gruppe = $gruppe;
		$this->turnier1->klasse = $klasse;
		$this->turnier1->turnierart = $turnierart;
		return $this;
	}

	/**
	 * @return EinzelwettbewerbSucheTurnier
	 */
	public function getTurnier2()
	{
		return $this->turnier2;
	}

	/**
	 * @param $gruppe
	 * @param $klasse
	 * @param $turnierart
	 * @return $this
	 */
	public function setTurnier2($gruppe, $klasse, $turnierart)
	{
		$this->turnier2->gruppe = $gruppe;
		$this->turnier2->klasse = $klasse;
		$this->turnier2->turnierart = $turnierart;
		return $this;
	}

	/**
	 * @return mixed
	 */
	public function getKonjunktion()
	{
		return $this->konjunktion;
	}

	/**
	 * @param $konjunktion
	 * @return $this
	 */
	public function setKonjunktion($konjunktion)
	{
		$this->konjunktion = $konjunktion;
		return $this;
	}
}