<?php
namespace Tanzsport\API\Turnier;

class AbstractSuche
{

	/**
	 * @var int
	 */
	private $turnierNr;

	/**
	 * @var string
	 */
	private $von;

	/**
	 * @var string
	 */
	private $bis;

	/**
	 * @var string
	 */
	private $plzVon;

	/**
	 * @var string
	 */
	private $plzBis;

	/**
	 * @var array
	 */
	private $landesverbaende;

	/**
	 * @var string
	 */
	private $seite = 0;

	/**
	 * @var string
	 */
	private $anzahl = 10;

	public function __construct()
	{
		$this->landesverbaende = array();
	}

	/**
	 * @return string
	 */
	public function getVon()
	{
		return $this->von;
	}

	/**
	 * @param $von
	 * @return $this
	 */
	public function setVon($von)
	{
		$this->von = $von;
		return $this;
	}

	/**
	 * @return string
	 */
	public function getBis()
	{
		return $this->bis;
	}

	/**
	 * @param $bis
	 * @return $this
	 */
	public function setBis($bis)
	{
		$this->bis = $bis;
		return $this;
	}

	/**
	 * @return string
	 */
	public function getPlzVon()
	{
		return $this->plzVon;
	}

	/**
	 * @param $plzVon
	 * @return $this
	 */
	public function setPlzVon($plzVon)
	{
		$this->plzVon = $plzVon;
		return $this;
	}

	/**
	 * @return string
	 */
	public function getPlzBis()
	{
		return $this->plzBis;
	}

	/**
	 * @param $plzBis
	 * @return $this
	 */
	public function setPlzBis($plzBis)
	{
		$this->plzBis = $plzBis;
		return $this;
	}

	/**
	 * @return array
	 */
	public function getLandesverbaende()
	{
		return $this->landesverbaende;
	}

	/**
	 * @param $landesverband
	 * @return $this
	 */
	public function addLandesverband($landesverband)
	{
		if ($landesverband != null && !in_array($landesverband, $this->landesverbaende)) {
			$this->landesverbaende[] = $landesverband;
		}
		return $this;
	}

	/**
	 * @return string
	 */
	public function getSeite()
	{
		return $this->seite;
	}

	/**
	 * @param $seite
	 * @return mixed
	 */
	public function setSeite($seite)
	{
		$this->seite = $seite;
		return $this;
	}

	/**
	 * @return string
	 */
	public function getAnzahl()
	{
		return $this->anzahl;
	}

	/**
	 * @param $anzahl
	 * @return $this
	 */
	public function setAnzahl($anzahl)
	{
		$this->anzahl = $anzahl;
		return $this;
	}

	/**
	 * @return int
	 */
	public function getTurnierNr()
	{
		return $this->turnierNr;
	}

	/**
	 * @param $turnierNr
	 * @return $this
	 */
	public function setTurnierNr($turnierNr)
	{
		$this->turnierNr = $turnierNr;
		return $this;
	}
}