<?php
namespace Tanzsport\API\Lehrgang\Resource;

use Tanzsport\API\AbstractResource;

class LehrgaengeResource extends AbstractResource
{

	/**
	 * @param $von Datum von (TT.MM.JJJJ)
	 * @param $bis Datum bis (TT.MM.JJJJ)
	 * @param string|array|null $typen
	 * @param string|array|null $ausrichter
	 * @param int $seite
	 * @param int $anzahl
	 * @throws \InvalidArgumentException
	 */
	public function find($von, $bis, $typen = null, $ausrichter = null, $seite = 0, $anzahl = 10)
	{
		// @codeCoverageIgnoreStart
		if ($von == null) {
			throw new \InvalidArgumentException("Datum von erforderlich!");
		}
		if ($bis == null) {
			throw new \InvalidArgumentException("Datum bis erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$request = $this->createRequest('/1/ldb/lehrgaenge');
		$request->getQuery()->add('von', $von);
		$request->getQuery()->add('bis', $bis);

		if ($typen != null) {
			if (is_array($typen)) {
				foreach ($typen as $typ) {
					$request->getQuery()->add('typ', $typ);
				}
			} else {
				$request->getQuery()->add('typ', $typen);
			}
		}

		if ($ausrichter != null) {
			if (is_array($ausrichter)) {
				foreach ($ausrichter as $a) {
					$request->getQuery()->add('ausrichter', $a);
				}
			} else {
				$request->getQuery()->add('ausrichter', $ausrichter);
			}
		}

		if ($seite != null) {
			$request->getQuery()->add('seite', $seite);
		}

		if ($anzahl != null) {
			$request->getQuery()->add('anzahl', $anzahl);
		}

		return $request->send()->json();
	}
}