<?php
namespace Tanzsport\API\Lehrgang;

class Lehrgang
{

	/**
	 * @var \stdClass
	 */
	private $apiData;

	/**
	 * @var \DateTime
	 */
	private $datum;

	public function __construct(\stdClass $apiData)
	{
		$this->apiData = $apiData;
		$this->datum = \DateTime::createFromFormat('Y-m-d\TH:i:s.\0\0\0O', $this->apiData->datum)->setTimezone(new \DateTimeZone('Europe/Berlin'));
	}

	public function __get($value)
	{
		if (isset($this->apiData->$value)) {
			switch ($value) {
				case 'datum':
					return $this->datum;
				default:
					return $this->apiData->$value;
			}
		}
		return;
	}

	public function __isset($value)
	{
		return isset($this->apiData->$value);
	}

	public function isErwerb()
	{
		return isset($this->typ) && $this->typ == 'ERWERB';
	}
}