<?php
namespace Tanzsport\API;

use Doctrine\Common\Cache\FilesystemCache;
use Guzzle\Cache\DoctrineCacheAdapter;
use Guzzle\Http\Client;
use Guzzle\Http\Message\RequestInterface;
use Guzzle\Http\QueryAggregator\DuplicateAggregator;
use Guzzle\Plugin\Cache\CachePlugin;
use Guzzle\Plugin\Cache\DefaultCacheStorage;

class AbstractResource
{

	/**
	 * @var string
	 */
	private $endpoint;

	/**
	 * @var \Guzzle\Http\Client
	 */
	private $client;

	/**
	 * @var \Guzzle\Plugin\Cache\CachePlugin
	 */
	private $cachePlugin;

	/**
	 * @var string
	 */
	private $cacheDir;

	public function __construct($endpoint, $enableCache = false, $cacheDir = null)
	{
		// @codeCoverageIgnoreStart
		if ($endpoint == null) {
			throw new \InvalidArgumentException("Endpoint erforderlich!");
		}
		// @codeCoverageIgnoreEnd

		$this->endpoint = $endpoint;
		$this->client = new Client();

		// @codeCoverageIgnoreStart
		if ($enableCache) {
			if ($cacheDir == null) {
				$this->cacheDir = sys_get_temp_dir() . '/tdapi';
			} else {
				$this->cacheDir = $cacheDir . '/tdapi';
			}
			$this->autocreateCacheDir();

			$this->cachePlugin = new CachePlugin(array(
				'storage' => new DefaultCacheStorage(new DoctrineCacheAdapter(new FilesystemCache($this->cacheDir)))
			));

			$this->client->addSubscriber($this->cachePlugin);
		}
		// @codeCoverageIgnoreEnd
	}

	/**
	 * @param $relativeUrl
	 * @return \Guzzle\Http\Message\RequestInterface
	 */
	protected function createRequest($relativeUrl)
	{
		$req = $this->client->get($this->getEndpointUrl($relativeUrl));
		$req->getQuery()->setAggregator(new DuplicateAggregator());
		return $req;
	}

	protected function getEndpointUrl($relativeUrl)
	{
		return sprintf('%1$s%2$s', $this->endpoint, $relativeUrl);
	}

	/**
	 * @codeCoverageIgnore
	 */
	private function autocreateCacheDir()
	{
		if (!is_dir($this->cacheDir)) {
			mkdir($this->cacheDir, 0777, true);
		}
	}
}
