<?php

declare(strict_types=1);

System::loadLanguageFile('tl_content');

$GLOBALS['TL_DCA']['tl_slideshows'] = array
(

	// Config
	'config' => array
	(
		'dataContainer'               => 'Table',
		'ctable'                      => array('tl_slideshow'),
		'enableVersioning'            => true,
		'onload_callback'             => array(array('mapi.slideshow.dca', 'checkState')),
		'sql' => array
		(
			'keys' => array 
			(
				'id' => 'primary'
			)
		),
	),

	// List
	'list' => array
	(
		'sorting' => array
		(
			'mode'                    => 1,
			'fields'                  => array('title'),
			'flag'                    => 1,
			'panelLayout'             => 'sort'
		),
		'label' => array
		(
			'fields'                  => array('title','fallback'),
			'format'                  => '%s',
			'label_callback'          => array('mapi.slideshow.dca', 'getTitle')
		),
		'global_operations' => array
		(
			'all' => array
			(
				'label'               => &$GLOBALS['TL_LANG']['MSC']['all'],
				'href'                => 'act=select',
				'class'               => 'header_edit_all',
				'attributes'          => 'onclick="Backend.getScrollOffset();" accesskey="e"'
			)
		),
		'operations' => array
		(
			'edit' => array
			(
				'label'               => &$GLOBALS['TL_LANG']['tl_slideshows']['edit'],
				'href'                => 'table=tl_slideshow',
				'icon'                => 'edit.svg'
			),
			'editheader' => array
			(
				'label'               => &$GLOBALS['TL_LANG']['tl_slideshows']['editheader'],
				'href'                => 'act=edit',
				'icon'                => 'header.gif'
			),
			'copy' => array
			(
				'label'               => &$GLOBALS['TL_LANG']['tl_slideshows']['copy'],
				'href'                => 'act=copy',
				'icon'                => 'copy.gif',
				'showInHeader'        => true
			),
			'delete' => array
			(
				'label'               => &$GLOBALS['TL_LANG']['tl_slideshows']['delete'],
				'href'                => 'act=delete',
				'icon'                => 'delete.gif',
				'attributes'          => 'onclick="if (!confirm(\'' . $GLOBALS['TL_LANG']['MSC']['deleteConfirm'] . '\')) return false; Backend.getScrollOffset();"',
				'showInHeader'        => true
			)
		)
	),

	// Palettes
	'palettes' => array
	(
		'default'                     => '{slideshow_config_legend},title,selected_sites;{slideshow_config_extra:hide},fallback'
	),

	// Fields
	'fields' => array
	(
		'id' => array
		(
			'sql'                     => "int(10) unsigned NOT NULL auto_increment",
		),
		'tstamp' => array
		(
			'label'                   => &$GLOBALS['TL_LANG']['tl_slideshows']['tstamp'],
			'sql'                     => "int(10) unsigned NOT NULL default '0'",
		),
		'title' => array
		(
            'exclude'                 => true,
            'filter'                  => true,
			'search'                  => true,
			'sorting'                 => true,
            'inputType'               => 'text',
			'eval'                    => array('mandatory'=>true, 'minlength'=>1, 'maxlength'=>255, 'tl_class'=>'w50'),
			'sql'                     => "varchar(255) NOT NULL default ''"
		),
		'selected_sites' => array
		(
			'exclude'                 => true,
            'inputType'               => 'pageTree',
			'eval'                    => array('mandatory'=>false, 'fieldType'=>'checkbox', 'multiple'=>true, 'tl_class'=>'clr'),
			'sql'                     => "blob NULL"
		),
		'fallback' => array
		(
			'exclude'                 => true,
            'filter'                  => true,
			'sorting'                 => true,
			'inputType'               => 'checkbox',
			'default'                 => '0',
			'sql'                     => "char(1) NOT NULL default ''",
			'eval'                    => array('tl_class'=>'w50 clr'),
			'save_callback'           => array(array('mapi.slideshow.dca', 'checkFallback'))
		)
	)
);