<?php

declare(strict_types=1);

namespace Mapi\SlideshowBundle\Controller\FrontendModule;

use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\FrontendTemplate;
use Contao\ModuleModel;
use Contao\Template;
use Contao\Database;
use Contao\Database\Result;
use Contao\Controller;
use Contao\System;
use Contao\Model\Collection;
use Contao\FilesModel;
use Contao\StringUtil;
use Contao\Input;
use Contao\Config;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Mapi\SlideshowBundle\Model\SlideshowModel;
use Mapi\SlideshowBundle\Model\SlideshowsModel;

/**
 * @FrontendModule("slideshow",
 *   category="miscellaneous",
 *   template="mod_slideshow",
 *   renderer="forward"
 * )
 */
class SlideshowModule extends AbstractFrontendModuleController
{
    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {

		if ($model->slideshowTpl) :
			$template = new \FrontendTemplate($model->slideshowTpl);
		endif;

        global $objPage;

        // get all slideshows as a collection
        $objAllSlideshows = SlideshowsModel::findAll();

        $options = [
            'order' => 'sorting ASC'
        ];

        // check if slideshow is selected for actual $objPage->id
        if ($objAllSlideshows) :
            foreach ($objAllSlideshows as $objSlideshows) :
                 if (in_array($objPage->id, \StringUtil::deserialize($objSlideshows->selected_sites, true))) :
                    $objSlideshow = SlideshowModel::findBy(['invisible = ?', 'pid = ?'], ['', $objSlideshows->id], $options);
                endif;
            endforeach;
        endif;

        // get fallback
        if (!$objSlideshow) :
            $objSlideshowFallback = \Database::getInstance()->prepare("SELECT * FROM tl_slideshows WHERE fallback=?")->execute(1);
            $objSlideshow = SlideshowModel::findBy(['invisible = ?', 'pid = ?'], ['', $objSlideshowFallback->id], $options);
        endif;

        $template->slideshow_elements = $this->process($template, $objSlideshow, $model);

        // add cssID to template
        if ($cssID = \StringUtil::deserialize($model->cssID, true)[0]) :
            $template->cssID = ' id="'.\StringUtil::deserialize($model->cssID, true)[0].'"';
        endif;

        // add cssCLASS to template
        $template->class = $model->slideshowTpl;
        if ($class = \StringUtil::deserialize($model->cssID, true)[1]) :
            $template->class .= ' '.$class;
        endif;

        return $template->getResponse();
    }

    public function process(Template $template, Collection $objSlideshow_var = null, ModuleModel $model)
    {
        if ($objSlideshow_var) :

            foreach ($objSlideshow_var as $slideshow) :

                $isInvisible = $slideshow->invisible || ($slideshow->start && $slideshow->start > time()) || ($slideshow->stop && $slideshow->stop <= time());
                $tokenChecker = System::getContainer()->get('contao.security.token_checker');

                // check if file exists
                if (FilesModel::findByUuid($slideshow->singleSRC) && !$isInvisible) :

                    $slideshow->addImage = true;
                    // generate and add the image
                    $image = FilesModel::findByUuid($slideshow->singleSRC);
                    $sliderHelper = new \stdClass();
                    Controller::addImageToTemplate($sliderHelper, ['singleSRC' => $image->path, 'size' => \StringUtil::deserialize($model->size, true),], null, null, $image);
                    $slideshow->image = $sliderHelper;

                    // genereate alt and title tag if overwritten
                    if ($slideshow->overwriteMeta) :
                        $slideshow->image->picture['alt'] = $slideshow->alt;
                        $slideshow->image->picture['title'] = $slideshow->imageTitle;
                    endif;

                else :
                    // no image found
                    $slideshow->addImage = false;
                endif;

            endforeach;

            $objSlideshow_var->reset();

            return $objSlideshow_var;

        else :
 
            return array();
 
        endif;
    }

    public function process_course_programs(Template $template, Array $arrSlider, ModuleModel $model)
    {
        if ($arrSlider) :

            foreach ($arrSlider as $key => $item) :

                // check if file exists
                if (FilesModel::findByUuid($item['singleSRC_slideshow'])) :

                    $arrSlider[$key]['addImage'] = true;
                    // generate and add the image
                    $image = FilesModel::findByUuid($item['singleSRC_slideshow']);
                    $sliderHelper = new \stdClass();
                    Controller::addImageToTemplate($sliderHelper, ['singleSRC' => $image->path, 'size' => \StringUtil::deserialize($model->size, true),], null, null, $image);
                    $arrSlider[$key]['image'] = $sliderHelper;

                    // genereate alt and title tag if overwritten
                    if ($item['alt_slideshow']) : $arrSlider[$key]['image']->picture['alt'] = $item['alt_slideshow']; endif;
                    if ($item['imageTitle_slideshow']) : $arrSlider[$key]['image']->picture['title'] = $item['imageTitle_slideshow']; endif;
  
                else :
                    // no image found
                    $arrSlider[$key]['addImage'] = false;
                endif;

            endforeach;

            return $arrSlider;

        else :
 
            return array();
 
        endif;
    }

	public function isHidden()
	{
		$isInvisible = $this->invisible || ($this->start && $this->start > time()) || ($this->stop && $this->stop <= time());

		// The element is visible, so show it
		if (!$isInvisible)
		{
			return false;
		}

		$tokenChecker = System::getContainer()->get('contao.security.token_checker');

		// Preview mode is enabled, so show the element
		if ($tokenChecker->hasBackendUser() && $tokenChecker->isPreviewMode())
		{
			return false;
		}

		$request = System::getContainer()->get('request_stack')->getCurrentRequest();

		// We are in the back end, so show the element
		if ($request && System::getContainer()->get('contao.routing.scope_matcher')->isBackendRequest($request))
		{
			return false;
		}

		return true;
	}

}