<?php

declare(strict_types=1);

namespace Mapi\SlideshowBundle\DataContainer;

use Contao\BackendUser;
use Contao\Config;
use Contao\Controller;
use Contao\CoreBundle\Framework\ContaoFrameworkInterface;
use Contao\Database;
use Contao\Database\Result;
use Contao\DataContainer;
use Contao\DcaExtractor;
use Contao\DiffRenderer;
use Contao\FrontendUser;
use Contao\Image;
use Contao\Image\ResizeConfiguration;
use Contao\Input;
use Contao\Model;
use Contao\RequestToken;
use Contao\StringUtil;
use Contao\System;
use Contao\Validator;
use Symfony\Component\DependencyInjection\ContainerInterface;

class Slideshow
{

    public function getTitle($row, $label, DataContainer $dc, $args)
    {
        $result = "<strong>". $label ."</strong>";

        // label count element(s)
        $objCount = \Database::getInstance()->prepare("SELECT COUNT(*) AS cnt FROM tl_slideshow WHERE pid=?")->execute($row['id']);
        $result .= "<span class='slideshows__label_elements'><abbr title='Anzahl der Slideshow-Elemente.'><span class='icon_gallery'></span>(".$objCount->cnt.")</abbr></span>";

        // label slideshow fallback
        if ($args[1] == "ja") :
            $result .= "<span class='slideshows__la1el_fallback'> <abbr title='Fallback: Diese Slideshow wird angezeigt, wenn einer Seite keine Slideshow zugeordnet wurde.'><span class='icon_fallback'></span></abbr></span>";
        endif;

        // label selected sites
        if ($args[1] != "ja") : // don't display if it is the fallback
            if ($row['selected_sites']) :
                $sites_to_display = \StringUtil::deserialize($row['selected_sites'],true);
                $result .= "<div class='slideshows__label_selected_sites_prepend'>Wird verwendet auf den Seiten:";
                foreach ($sites_to_display as $site) {
                    $objTitle = \Database::getInstance()->prepare("SELECT * FROM tl_page WHERE id=?")->execute($site);
                    while ($objTitle->next()) {
                        $result .= " <span class='slideshows__label_selected_sites_item'>[<abbr title='Seiten-ID: ".$objTitle->id."'>".$objTitle->title."</abbr>]</span>";
                    }
                }
                $result .= "</div>";
            else :
                $result .= "<div class='slideshows__label_no_selected_sites'>Wird auf keiner Seite verwendet.</div>";
            endif;
        endif;

        return $result;

    }

    public function checkState($dc)
    {

        if (Input::get('act') != 'edit') :

            $objCountFallback = \Database::getInstance()->prepare("SELECT COUNT(*) AS cnt FROM tl_slideshows WHERE fallback=?")->execute(1);
            if ($objCountFallback->cnt <= 0) :
                \Message::addInfo("Es wurde kein Fallback gesetzt.<br>Setzen Sie mindestens eine Slideshow als Fallback ein.");
            endif;

            $objFallback = \Database::getInstance()->prepare("SELECT * FROM tl_slideshows WHERE fallback=?")->execute(1);
            while ($objFallback->next()) {
                $objCount = \Database::getInstance()->prepare("SELECT COUNT(*) AS cnt FROM tl_slideshow WHERE pid=?")->execute($objFallback->id);
                if ($objCount->cnt == 0) :
                    \Message::addError("Die Slideshow <em>".$objFallback->title."</em> wurde als Fallback gesetzt.<br>Sie enthält keine Elemente. Fügen Sie dem Fallback Elemente hinzu!");
                else :
                    \Message::addConfirmation("Die Slideshow <em>".$objFallback->title."</em> wurde als Fallback gesetzt.<br>Sie wird auf Seiten verwendet, wenn diesen keine Slideshow zugewiesen wurde.");
                endif;
            }

            $objSlideshow = \Database::getInstance()->prepare("SELECT * FROM tl_slideshows WHERE fallback=?")->execute(0);
            while ($objSlideshow->next()) {
                $objCount = \Database::getInstance()->prepare("SELECT COUNT(*) AS cnt FROM tl_slideshow WHERE pid=?")->execute($objSlideshow->id);
                if ($objCount->cnt == 0) :
                    \Message::addError("Die Slideshow <em>".$objSlideshow->title."</em> hat keine Elemente!");
                endif;
            }

        endif;

        return $dc;

    }

    public function ImageSizeInformation($dc)
    {

        if (Input::get('act') == 'edit') :
            \Message::addInfo("Die Einstellungen für die Bildgröße werden im Frontend-Modul getätigt.");
        endif;
        return $dc;

    }

    public function checkFallback($varValue, DataContainer $dc)
    {
        if (\Input::post('fallback')) :

            $objCount = \Database::getInstance()->prepare("SELECT COUNT(*) AS cnt FROM tl_slideshows WHERE fallback=? AND NOT id=?")->execute(1,$dc->activeRecord->id);

            if ($objCount->cnt > 0) :
                throw new \Exception(sprintf($GLOBALS['TL_LANG']['tl_slideshow']['slideshow_is_set'], $varValue));
            endif;

        endif;

        return $varValue;
    }

    public function listSlides($arrRow)
    {
        $objFile = \FilesModel::findByPk($arrRow['singleSRC']);

        if ($objFile) :
            $html = '';
            $html .= '<div class="slideshow_list_element">';

                // image (left_col)
                $container = \System::getContainer();
                $rootDir = $container->getParameter('kernel.project_dir');
                $image = $container->get('contao.image.image_factory')->create($rootDir.'/'.$objFile->path, [80, 60, 'crop'])->getUrl($rootDir);
                $html .= '<div class="slideshow_list_element__image"><img src="'.$image.'" width="80" height="60"></div>';

                // image attributes/description (right_col)
                $html .= '<div class="slideshow_list_element__attributes">';

                    // path
                    $html .= '<div class="slideshow_list_element__path"><strong>'.$GLOBALS['TL_LANG']['tl_slideshow']['path'].'</strong>: '.$objFile->path.'</div>';

                    // metadata
                    $meta = \StringUtil::deserialize($objFile->meta,true);
                    $html .= '<div class="slideshow_list_element__metadata">';
                        if ($arrRow['overwriteMeta']) :
                            $html .= '<strong>'.$GLOBALS['TL_LANG']['tl_slideshow']['alt'].'</strong>:&nbsp;'.$arrRow['alt'].'<br>';
                            $html .= '<strong>'.$GLOBALS['TL_LANG']['tl_slideshow']['imageTitle'].'</strong>:&nbsp;'.$arrRow['imageTitle'].'';
                        else :
                            if ($meta[$GLOBALS['TL_LANGUAGE']]['alt']) :
                                $html .= '<strong>'.$GLOBALS['TL_LANG']['tl_slideshow']['alt'].'</strong>:&nbsp;'.$meta[$GLOBALS['TL_LANGUAGE']]['alt'].'<br>';
                            endif;
                            if ($meta[$GLOBALS['TL_LANGUAGE']]['title']) :
                                $html .= '<strong>'.$GLOBALS['TL_LANG']['tl_slideshow']['imageTitle'].'</strong>:&nbsp;'.$meta[$GLOBALS['TL_LANGUAGE']]['title'].'';
                            endif;
                        endif;
                        $html .= "</div>";

                $html .= '</div>';

            $html .= '</div>';

        else:

            $html = '';
            $html .= '<div class="slideshow_list_element">';

                // image (left_col)
                $html .= '<div class="slideshow_list_element__image slideshow_list_element__image--no-image"></div>';

                // image attributes/description (right_col)
                $html .= '<div class="slideshow_list_element__attributes">';

                    $html .= '<div class="slideshow_list_element__message"><strong class="red">Es wurde kein Bild gefunden!</strong><br>Wurde es ggf. aus der Dateiverwaltung gelöscht?</div>';

                $html .= '</div>';

            $html .= '</div>';

        endif;

        return $html;
    }

}