<?php

declare(strict_types=1);

Contao\System::loadLanguageFile('tl_content');

$GLOBALS['TL_DCA']['tl_site_elements_header'] = array
(

  // Config
  'config' => array
  (
    'dataContainer'               => 'Table',
    'enableVersioning'            => true,
    'sql' => array 
    (
      'keys' => array 
      (
        'id' => 'primary'
      )
    ),
  ),

  // List
  'list' => array
  (
    'sorting' => array
    (
      'mode'                    => 0,
      'fields'                  => array('header_element'),
      'flag'                    => 1,
      'panelLayout'             => ''
    ),
    'label' => array
    (
      'fields'                  => array('header_element'),
      'format'                  => '%s'
    ),
    'global_operations' => array
    (
    ),
    'operations' => array
    (
      'edit' => array
      (
        'label'               => &$GLOBALS['TL_LANG']['tl_site_elements_header']['edit'],
        'href'                => 'act=edit',
        'icon'                => 'edit.gif'
      ),
			'delete' => array
			(
				'href'                => 'act=delete',
				'icon'                => 'delete.svg',
				'attributes'          => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"'
      ),
			'show' => array
			(
				'href'                => 'act=show',
				'icon'                => 'show.svg'
			)
    )
  ),

  // Palettes
  'palettes' => array
  (
    'default' => '{header_name_legend},header_element;{header_contact_legend},name,street,house_number,zip,city,phone,fax,email,url,titleText,linkTitle;{header_quicklinks_legend},quicklinks'
  ),

  // Fields
  'fields' => array
  (
    'id' => array
    (
      'sql'                     => "int(10) unsigned NOT NULL auto_increment",
    ),
    'tstamp' => array
    (
      'sql'                     => "int(10) unsigned NOT NULL default '0'",
    ),
    'header_element' => array
    (

      'exclude'                 => true,
      'sorting'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>true, 'minlength'=>1, 'maxlength'=>255, 'tl_class'=>'clr w50'),
      'sql'                     => "varchar(64) NOT NULL"
    ),
    'name' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'clr w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'street' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'clr w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'house_number' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'zip' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'city' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'phone' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'clr w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'fax' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'email' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'clr w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
	'url' => array
	(
		'exclude'                 => true,
		'inputType'               => 'text',
		'eval'                    => array('rgxp'=>'url', 'decodeEntities'=>true, 'maxlength'=>255, 'dcaPicker'=>true, 'addWizardClass'=>false, 'tl_class'=>'clr w50'),
		'sql'                     => "varchar(255) NOT NULL default ''"
	),
	'titleText' => array
	(
		'exclude'                 => true,
		'inputType'               => 'text',
		'eval'                    => array('maxlength'=>255, 'tl_class'=>'clr w50'),
		'sql'                     => "varchar(255) NOT NULL default ''"
	),
	'linkTitle' => array
	(
		'exclude'                 => true,
		'inputType'               => 'text',
		'eval'                    => array('maxlength'=>255, 'tl_class'=>'w50'),
		'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'quicklinks' => array
    (
      'exclude'                 => true,
      'inputType'               => 'pageTree',
      'sorting'                 => true,
      'eval'                    => array('fieldType'=>'checkbox', 'orderField'=>'quicklinks_orderPages', 'multiple'=>true, 'tl_class'=>'clr'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'quicklinks_orderPages' => array
    (
      'label'                   => &$GLOBALS['TL_LANG']['tl_module']['orderSRC'],
      'sql'                     => "blob NULL"
    )
  )
);

class tl_site_elements_header extends Backend
{
}