<?php

declare(strict_types=1);

Contao\System::loadLanguageFile('tl_content');

$GLOBALS['TL_DCA']['tl_site_elements_footer'] = array
(

  // Config
  'config' => array
  (
    'dataContainer'               => 'Table',
    'enableVersioning'            => true,
    'sql' => array 
    (
      'keys' => array 
      (
        'id' => 'primary'
      )
    ),
  ),

  // List
  'list' => array
  (
    'sorting' => array
    (
      'mode'                    => 0,
      'fields'                  => array('footer_element'),
      'flag'                    => 1,
      'panelLayout'             => ''
    ),
    'label' => array
    (
      'fields'                  => array('footer_element'),
      'format'                  => '%s'
    ),
    'global_operations' => array
    (
    ),
    'operations' => array
    (
      'edit' => array
      (
        'label'               => &$GLOBALS['TL_LANG']['tl_site_elements_footer']['edit'],
        'href'                => 'act=edit',
        'icon'                => 'edit.gif'
      ),
			'delete' => array
			(
				'href'                => 'act=delete',
				'icon'                => 'delete.svg',
				'attributes'          => 'onclick="if(!confirm(\'' . ($GLOBALS['TL_LANG']['MSC']['deleteConfirm'] ?? null) . '\'))return false;Backend.getScrollOffset()"'
      ),
			'show' => array
			(
				'href'                => 'act=show',
				'icon'                => 'show.svg'
			)
    )
  ),

  // Palettes
  'palettes' => array
  (
    '__selector__'                => array('addImage', 'overwriteMeta'),
    'default' => '{footer_name_legend},footer_element;{footer_contact_legend},name,street,house_number,zip,city,phone,fax,email,url,titleText,linkTitle;{footer_quicklinks_legend},quicklinks;{footer_image_legend},addImage'
  ),

	// Subpalettes
	'subpalettes' => array
	(
		'addImage'                    => 'singleSRC,size,overwriteMeta',
    'overwriteMeta'               => 'alt,imageTitle,imageUrl,imageTarget'
	),

  // Fields
  'fields' => array
  (
    'id' => array
    (
      'sql'                     => "int(10) unsigned NOT NULL auto_increment",
    ),
    'tstamp' => array
    (
      'sql'                     => "int(10) unsigned NOT NULL default '0'",
    ),
    'footer_element' => array
    (

      'exclude'                 => true,
      'sorting'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('mandatory'=>true, 'minlength'=>1, 'maxlength'=>255, 'tl_class'=>'clr w50'),
      'sql'                     => "varchar(64) NOT NULL"
    ),
    'name' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'clr w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'street' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'clr w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'house_number' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'zip' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'city' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'phone' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'clr w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'fax' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'email' => array
    (
      'exclude'                 => true,
      'inputType'               => 'text',
      'eval'                    => array('maxlength'=>255, 'tl_class'=>'clr w50'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
		'url' => array
		(
			'exclude'                 => true,
			'inputType'               => 'text',
			'eval'                    => array('rgxp'=>'url', 'decodeEntities'=>true, 'maxlength'=>255, 'dcaPicker'=>true, 'addWizardClass'=>false, 'tl_class'=>'clr w50'),
			'sql'                     => "varchar(255) NOT NULL default ''"
		),
		'titleText' => array
		(
			'exclude'                 => true,
			'inputType'               => 'text',
			'eval'                    => array('maxlength'=>255, 'tl_class'=>'clr w50'),
			'sql'                     => "varchar(255) NOT NULL default ''"
		),
		'linkTitle' => array
		(
			'exclude'                 => true,
			'inputType'               => 'text',
			'eval'                    => array('maxlength'=>255, 'tl_class'=>'w50'),
			'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'quicklinks' => array
    (
      'exclude'                 => true,
      'inputType'               => 'pageTree',
      'sorting'                 => true,
      'eval'                    => array('fieldType'=>'checkbox', 'orderField'=>'quicklinks_orderPages', 'multiple'=>true, 'tl_class'=>'clr'),
      'sql'                     => "varchar(255) NOT NULL default ''"
    ),
    'quicklinks_orderPages' => array
    (
      'label'                   => &$GLOBALS['TL_LANG']['tl_module']['orderSRC'],
      'sql'                     => "blob NULL"
    ),
		'addImage' => array
		(
      'label'                   => &$GLOBALS['TL_LANG']['tl_content']['addImage'],
			'exclude'                 => true,
			'inputType'               => 'checkbox',
			'eval'                    => array('submitOnChange'=>true),
			'sql'                     => "char(1) NOT NULL default ''"
		),
		'singleSRC' => array
		(
			'label'                   => &$GLOBALS['TL_LANG']['tl_content']['singleSRC'],
			'exclude'                 => true,
			'inputType'               => 'fileTree',
			'eval'                    => array('filesOnly'=>true, 'fieldType'=>'radio', 'tl_class'=>'clr'),
			'sql'                     => "binary(16) NULL"
    ),
		'size' => array
		(
			'label'                   => &$GLOBALS['TL_LANG']['tl_content']['size'],
      'exclude'                 => true,
			'inputType'               => 'imageSize',
			'reference'               => &$GLOBALS['TL_LANG']['MSC'],
			'eval'                    => array('rgxp'=>'natural', 'includeBlankOption'=>true, 'nospace'=>true, 'helpwizard'=>true, 'tl_class'=>'w50'),
			'options_callback' => static function ()
			{
				return Contao\System::getContainer()->get('contao.image.image_sizes')->getOptionsForUser(Contao\BackendUser::getInstance());
			},
			'sql'                     => "varchar(255) NOT NULL default ''"
		),
		'overwriteMeta' => array
		(
			'label'                   => &$GLOBALS['TL_LANG']['tl_content']['overwriteMeta'],
			'exclude'                 => true,
			'inputType'               => 'checkbox',
			'eval'                    => array('submitOnChange'=>true, 'tl_class'=>'w50 clr'),
			'sql'                     => "char(1) NOT NULL default ''"
		),
		'alt' => array
		(
			'label'                   => &$GLOBALS['TL_LANG']['tl_content']['alt'],
			'exclude'                 => true,
			'inputType'               => 'text',
			'eval'                    => array('maxlength'=>255, 'tl_class'=>'w50'),
			'sql'                     => "varchar(255) NOT NULL default ''"
		),
		'imageTitle' => array
		(
      'label'                   => &$GLOBALS['TL_LANG']['tl_content']['imageTitle'],
			'exclude'                 => true,
			'inputType'               => 'text',
			'eval'                    => array('maxlength'=>255, 'tl_class'=>'w50'),
			'sql'                     => "varchar(255) NOT NULL default ''"
		),
		'imageUrl' => array
		(
			'label'                   => &$GLOBALS['TL_LANG']['tl_content']['imageUrl'],
			'exclude'                 => true,
			'inputType'               => 'text',
			'eval'                    => array('rgxp'=>'url', 'decodeEntities'=>true, 'maxlength'=>255, 'dcaPicker'=>true, 'addWizardClass'=>false, 'tl_class'=>'w50'),
			'sql'                     => "varchar(255) NOT NULL default ''"
		),
		'imageTarget' => array
		(
			'label'                   => &$GLOBALS['TL_LANG']['MSC']['target'],
			'exclude'                 => true,
			'inputType'               => 'checkbox',
			'eval'                    => array('tl_class'=>'w50 m12'),
			'sql'                     => "char(1) NOT NULL default ''"
		),
  )
);

class tl_site_elements_footer extends Backend
{
}