<?php

declare(strict_types=1);

use Contao\CoreBundle\DataContainer\PaletteManipulator;

System::loadLanguageFile('tl_content');

// Add palettes to tl_page (root)
PaletteManipulator::create()
	->addLegend('footer_legend', 'layout_legend', PaletteManipulator::POSITION_AFTER)
	->addField('footer_selection', 'footer_legend', PaletteManipulator::POSITION_APPEND)
	->applyToPalette('root', 'tl_page');

// Add palettes to tl_page (rootfallback)
PaletteManipulator::create()
	->addLegend('footer_legend', 'layout_legend', PaletteManipulator::POSITION_AFTER)
	->addField('footer_selection', 'footer_legend', PaletteManipulator::POSITION_APPEND)
	->applyToPalette('rootfallback', 'tl_page');

// Add fields to tl_page
$GLOBALS['TL_DCA']['tl_page']['fields']['footer_selection'] = array
(
	'exclude'                 => true,
	'inputType'               => 'select',
	'options_callback'        => array('mapi.siteelements.dca', 'getFooters'),
	'eval'                    => array('includeBlankOption'=>true, 'chosen'=>true, 'maxlength'=>255, 'tl_class'=>'clr w50'),
	'sql'                     => "varchar(255) NOT NULL default ''"
);

// Add palettes to tl_page (root)
PaletteManipulator::create()
	->addLegend('header_legend', 'layout_legend', PaletteManipulator::POSITION_AFTER)
	->addField('header_selection', 'header_legend', PaletteManipulator::POSITION_APPEND)
	->applyToPalette('root', 'tl_page');

// Add palettes to tl_page (rootfallback)
PaletteManipulator::create()
	->addLegend('header_legend', 'layout_legend', PaletteManipulator::POSITION_AFTER)
	->addField('header_selection', 'header_legend', PaletteManipulator::POSITION_APPEND)
	->applyToPalette('rootfallback', 'tl_page');

// Add fields to tl_page
$GLOBALS['TL_DCA']['tl_page']['fields']['header_selection'] = array
(
	'exclude'                 => true,
	'inputType'               => 'select',
	'options_callback'        => array('mapi.siteelements.dca', 'getHeaders'),
	'eval'                    => array('includeBlankOption'=>true, 'chosen'=>true, 'maxlength'=>255, 'tl_class'=>'clr w50'),
	'sql'                     => "varchar(255) NOT NULL default ''"
);