<?php

declare(strict_types=1);

namespace Mapi\SiteElementsBundle\Controller\FrontendModule;

use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\FrontendTemplate;
use Contao\ModuleModel;
use Contao\Template;
use Contao\Database;
use Contao\Database\Result;
use Contao\Controller;
use Contao\System;
use Contao\Model\Collection;
use Contao\FilesModel;
use Contao\PageModel;
use Contao\StringUtil;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Mapi\SiteElementsBundle\Model\FooterModel;

/**
 * @FrontendModule("footer",
 *   category="miscellaneous",
 *   template="mod_footer",
 *   renderer="forward"
 * )
 */
class FooterModule extends AbstractFrontendModuleController
{
    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {

        if ($model->footerTpl) :
            $template = new FrontendTemplate($model->footerTpl);
        endif;

        $cssIDarr = deserialize($model->cssID);
        $template->cssID = 'id="'.$cssIDarr[0].'"';
        $template->class = "mod_footer";
        if ($model->footerTpl) :
            $template->class .= " ".$model->footerTpl;
        endif;
        if ($cssIDarr[1]) :
            $template->class .= " ".$cssIDarr[1];
        endif;

        // get the root page and the selected footer id
        global $objPage;
        $objRootPage = PageModel::findById($objPage->rootId);
        $footerId = $objRootPage->footer_selection;

        // get the selected footer object
        $objFooter = FooterModel::findBy('id', $footerId);

        // check if file exists
        if (FilesModel::findByUuid($objFooter->singleSRC)) :
            $objFooter->addImage = true;
            // generate and add the image
            $image = FilesModel::findByUuid($objFooter->singleSRC);
            $FooterHelper = new \stdClass();
            Controller::addImageToTemplate($FooterHelper, ['singleSRC' => $image->path, 'size' => \StringUtil::deserialize($objFooter->size, true),], null, null, $image);
            $objFooter->image = $FooterHelper;
            // genereate alt and title tag if overwritten
            if ($objFooter->overwriteMeta) :
                $objFooter->image->picture['alt'] = $objFooter->alt;
                $objFooter->image->picture['title'] = $objFooter->imageTitle;
            else :
                $objFooter->imageUrl = false;
            endif;
        else :
            // no image found
            $objFooter->addImage = false;
        endif;

        $template->footer_selection = $objRootPage->footer_selection;
        $template->footer = $objFooter;
        $template->footer->quicknav = $this->generateQuicklinks($objFooter->quicklinks_orderPages, $template->class);

        return $template->getResponse();

    }

    // generate quicklinks navigation
    public function generateQuicklinks($orderPages_ids, $cssClass)
    {
        if (!empty($orderPages_ids)) :

            $quicknav = "";
            $quicknav .= "<nav class=\"".$cssClass."__element ".$cssClass."__element_quicknav\" itemscope itemtype=\"http://schema.org/SiteNavigationElement\">";
            $quicknav .= "<ul>";

                $i = 0;
                $amoutPagesNotNull = 0;

                foreach (deserialize($orderPages_ids) as $orderPages_id) :
                    if (PageModel::findPublishedById($orderPages_id) != NULL) :
                        $amoutPagesNotNull++;
                    endif;
                endforeach;

                foreach (deserialize($orderPages_ids) as $orderPages_id) :

                        $objPage = PageModel::findPublishedById($orderPages_id);

                        if ($objPage != NULL) :

                            $arrPage = $objPage->row();

                            if ($arrPage['type'] == "forward") :
                                // redirect to internal page
                                if ($arrPage['jumpTo']) :
                                    $PageUrl = Controller::generateFrontendUrl(PageModel::findPublishedById($arrPage['jumpTo'])->row());
                                else:
                                    $PageUrl = "";
                                endif;
                            elseif ($arrPage['type'] == "redirect") :
                                // redirect to external page
                                $PageUrl = $arrPage['url'];
                            else :
                                // regular page
                                $PageUrl = Controller::generateFrontendUrl($arrPage);
                            endif;

                            // generate link
                            $quicknav .= "<li class=\"".(($i % 2 == 0) ? 'odd' : 'even') . (($i == 0) ? ' first' : '') . (($i == $amoutPagesNotNull-1) ? ' last' : '')."\">";
                            $quicknav .= "<a href=\"".$PageUrl."\" title=\"".$arrPage['title']."\"" . ($arrPage['target'] ? ' target="_blank" rel="external noopener"' : '') . " itemprop=\"url\"><span itemprop=\"name\">".$arrPage['title']."</span></a>";
                            $quicknav .= "</li>";
                            $i++;

                        endif;

                endforeach;

            $quicknav .= "</ul>";
            $quicknav .= "</nav>";

        endif;

        return $quicknav;

    }


}